/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.abstractions.recipes;

import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Recipe;
import org.zeith.hammerlib.abstractions.recipes.IVisualizedRecipe;
import org.zeith.hammerlib.client.utils.UV;

public interface IRecipeVisualizer<T extends Recipe<?>, VIS extends IVisualizedRecipe<T>> {
    public VisualizedRecipeGroup getGroup();

    public Class<VIS> getVisualizedType();

    public VIS visualize(T var1);

    public static <T extends Recipe<?>, VIS extends IVisualizedRecipe<T>> IRecipeVisualizer<T, VIS> simple(final Class<VIS> baseVisType, final VisualizedRecipeGroup group, final Function<T, VIS> fun) {
        return new IRecipeVisualizer<T, VIS>(){

            @Override
            public VisualizedRecipeGroup getGroup() {
                return group;
            }

            @Override
            public Class<VIS> getVisualizedType() {
                return baseVisType;
            }

            @Override
            public VIS visualize(T recipe) {
                return (IVisualizedRecipe)fun.apply(recipe);
            }
        };
    }

    public record VisualizedRecipeGroup(Component title, int width, int height, UV icon) {
    }
}

