/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.config.Config;
import org.zeith.hammerlib.api.config.ConfigException;
import org.zeith.hammerlib.util.configured.ConfiguredLib;
import org.zeith.hammerlib.util.configured.data.DecimalValueRange;
import org.zeith.hammerlib.util.configured.data.IntValueRange;
import org.zeith.hammerlib.util.configured.types.ConfigBoolean;
import org.zeith.hammerlib.util.configured.types.ConfigCategory;
import org.zeith.hammerlib.util.configured.types.ConfigString;
import org.zeith.hammerlib.util.java.ReflectionUtil;
import org.zeith.hammerlib.util.shaded.json.JSONObject;

public interface IConfigStructure {
    default public void toNetwork(CompoundTag tag) {
        for (Field field : ReflectionUtil.getFieldsUpTo(this.getClass(), Object.class)) {
            if (field.isAnnotationPresent(Config.AvoidSync.class) || field.isAnnotationPresent(Config.LoadOnlyIn.class)) continue;
            try {
                String tmp0;
                Config.ConfigEntry ea = field.getAnnotation(Config.ConfigEntry.class);
                String name = ea != null && (tmp0 = ea.entry()) != null && !tmp0.isEmpty() ? ea.entry() : field.getName();
                Class<?> type = field.getType();
                if (IConfigStructure.class.isAssignableFrom(type)) {
                    IConfigStructure struct = (IConfigStructure)field.get(this);
                    if (struct == null) continue;
                    CompoundTag sub = new CompoundTag();
                    struct.toNetwork(sub);
                    tag.m_128365_(name, (Tag)sub);
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
                    tag.m_128405_(name, field.getInt(this));
                    continue;
                }
                if (Long.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type)) {
                    tag.m_128356_(name, field.getLong(this));
                    continue;
                }
                if (Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
                    tag.m_128350_(name, field.getFloat(this));
                    continue;
                }
                if (Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
                    tag.m_128347_(name, field.getDouble(this));
                    continue;
                }
                if (Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
                    tag.m_128379_(name, field.getBoolean(this));
                    continue;
                }
                if (String.class.equals(type)) {
                    tag.m_128359_(name, (String)field.get(this));
                    continue;
                }
                throw new ConfigException("Unknown field type for config root in field: " + field);
            }
            catch (Throwable err) {
                if (err instanceof ConfigException) {
                    ConfigException ce = (ConfigException)err;
                    throw ce;
                }
                if (err instanceof ReflectiveOperationException) {
                    HammerLib.LOG.error("Reflective operation occurred while writing configs to network from " + this.getClass().getName(), err);
                }
                throw new ConfigException(err);
            }
        }
    }

    default public void fromNetwork(CompoundTag tag) {
        for (Field field : ReflectionUtil.getFieldsUpTo(this.getClass(), Object.class)) {
            if (field.isAnnotationPresent(Config.AvoidSync.class) || field.isAnnotationPresent(Config.LoadOnlyIn.class)) continue;
            try {
                String tmp0;
                Config.ConfigEntry ea = field.getAnnotation(Config.ConfigEntry.class);
                String name = ea != null && (tmp0 = ea.entry()) != null && !tmp0.isEmpty() ? ea.entry() : field.getName();
                Class<?> type = field.getType();
                if (IConfigStructure.class.isAssignableFrom(type)) {
                    IConfigStructure struct = (IConfigStructure)field.get(this);
                    if (struct == null) {
                        struct = (IConfigStructure)UnsafeHacks.newInstance(type.asSubclass(IConfigStructure.class));
                        field.set(this, struct);
                    }
                    if (!tag.m_128425_(name, 10)) continue;
                    struct.toNetwork(tag.m_128469_(name));
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
                    field.setInt(this, tag.m_128451_(name));
                    continue;
                }
                if (Long.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type)) {
                    field.setLong(this, tag.m_128454_(name));
                    continue;
                }
                if (Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
                    field.setFloat(this, tag.m_128457_(name));
                    continue;
                }
                if (Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
                    field.setDouble(this, tag.m_128459_(name));
                    continue;
                }
                if (Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
                    field.setBoolean(this, tag.m_128471_(name));
                    continue;
                }
                if (String.class.equals(type)) {
                    field.set(this, tag.m_128461_(name));
                    continue;
                }
                throw new ConfigException("Unknown field type for config root in field: " + field);
            }
            catch (Throwable err) {
                if (err instanceof ConfigException) {
                    ConfigException ce = (ConfigException)err;
                    throw ce;
                }
                if (err instanceof ReflectiveOperationException) {
                    HammerLib.LOG.error("Reflective operation occurred while reading configs from network into " + this.getClass().getName(), err);
                }
                throw new ConfigException(err);
            }
        }
    }

    default public void load(ConfigCategory category) throws ConfigException {
        for (Field field : ReflectionUtil.getFieldsUpTo(this.getClass(), Object.class)) {
            if (field.isAnnotationPresent(Config.LoadOnlyIn.class) && FMLEnvironment.dist != field.getAnnotation(Config.LoadOnlyIn.class).value()) continue;
            try {
                Annotation entry;
                String tmp0;
                Config.ConfigEntry ea = field.getAnnotation(Config.ConfigEntry.class);
                String name = ea != null && (tmp0 = ea.entry()) != null && !tmp0.isEmpty() ? ea.entry() : field.getName();
                String comment = ea != null ? ea.comment() : null;
                Class<?> type = field.getType();
                if (IConfigStructure.class.isAssignableFrom(type)) {
                    ConfigCategory sub = (ConfigCategory)category.getElement(ConfiguredLib.CATEGORY, name).withComment(comment);
                    IConfigStructure struct = (IConfigStructure)field.get(this);
                    if (struct == null) {
                        struct = (IConfigStructure)UnsafeHacks.newInstance(type.asSubclass(IConfigStructure.class));
                        field.set(this, struct);
                    }
                    struct.load(sub);
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
                    entry = field.getAnnotation(Config.IntEntry.class);
                    field.setInt(this, category.getElement(ConfiguredLib.INT, name).withRange(IntValueRange.rangeClosed(entry.min(), entry.max())).withComment(comment).withDefault(entry.value()).getValue().intValue());
                    continue;
                }
                if (Long.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type)) {
                    entry = field.getAnnotation(Config.LongEntry.class);
                    field.setLong(this, category.getElement(ConfiguredLib.INT, name).withRange(IntValueRange.rangeClosed(entry.min(), entry.max())).withComment(comment).withDefault(entry.value()).getValue().longValue());
                    continue;
                }
                if (Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
                    entry = field.getAnnotation(Config.FloatEntry.class);
                    field.setFloat(this, category.getElement(ConfiguredLib.DECIMAL, name).withRange(DecimalValueRange.rangeClosed(entry.min(), entry.max())).withComment(comment).withDefault(entry.value()).getValue().floatValue());
                    continue;
                }
                if (Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
                    entry = field.getAnnotation(Config.DoubleEntry.class);
                    field.setDouble(this, category.getElement(ConfiguredLib.DECIMAL, name).withRange(DecimalValueRange.rangeClosed(entry.min(), entry.max())).withComment(comment).withDefault(entry.value()).getValue().doubleValue());
                    continue;
                }
                if (Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
                    entry = field.getAnnotation(Config.BooleanEntry.class);
                    field.setBoolean(this, ((ConfigBoolean)category.getElement(ConfiguredLib.BOOLEAN, name).withComment(comment)).withDefault(entry.value()).getValue());
                    continue;
                }
                if (String.class.equals(type)) {
                    entry = field.getAnnotation(Config.StringEntry.class);
                    String[] all = entry.allowed();
                    String nln = all.length > 0 ? "\n" + Arrays.stream(all).map(JSONObject::quote).collect(Collectors.joining(", ")) : "";
                    field.set(this, ((ConfigString)category.getElement(ConfiguredLib.STRING, name).withComment(comment)).withDefault(entry.value()).getValue());
                    continue;
                }
                throw new ConfigException("Unknown field type for config structure in field: " + field);
            }
            catch (Throwable err) {
                if (err instanceof ConfigException) {
                    ConfigException ce = (ConfigException)err;
                    throw ce;
                }
                if (err instanceof ReflectiveOperationException) {
                    HammerLib.LOG.error("Reflective operation occurred while applying configs into " + this.getClass().getName(), err);
                }
                throw new ConfigException(err);
            }
        }
    }
}

