/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.utils;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.zeith.hammerlib.client.utils.GLHelperHL;
import org.zeith.hammerlib.client.utils.IGLWritable;

public class GLBuffer {
    public final int buffer = GLHelperHL.glTask(() -> GL31.glGenBuffers());
    private boolean disposed = false;
    public int drawType = 35040;
    public int bufferKind = 35345;

    private void dispose() {
        if (this.disposed) {
            return;
        }
        GLHelperHL.glTaskAsync(() -> GL31.glDeleteBuffers((int)this.buffer));
        this.disposed = true;
    }

    public void bindBuffer() {
        GL31.glBindBuffer((int)this.bufferKind, (int)this.buffer);
    }

    public void bufferData(FloatBuffer data) {
        GLHelperHL.glTask(() -> {
            this.bindBuffer();
            GL31.glBufferData((int)this.bufferKind, (FloatBuffer)data, (int)this.drawType);
        });
    }

    public <T extends IGLWritable> void bufferData(T ... writables) {
        int size = writables[0].getFloatSize() * writables.length;
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)size);
        for (T w : writables) {
            w.writeFloats(buf::put);
        }
        buf.flip();
        this.bufferData(buf);
    }

    public void bindToShader(int program, int blockBinding, String bufBlockName) {
        GL31.glUniformBlockBinding((int)program, (int)GL31.glGetUniformBlockIndex((int)program, (CharSequence)bufBlockName), (int)blockBinding);
        GL30.glBindBufferBase((int)this.bufferKind, (int)0, (int)this.buffer);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

