/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip.own.impl;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.zeith.hammerlib.tiles.tooltip.EnumTooltipEngine;
import org.zeith.hammerlib.tiles.tooltip.ITooltipTile;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltipProvider;
import org.zeith.hammerlib.tiles.tooltip.own.impl.GuiTooltip;
import org.zeith.hammerlib.tiles.tooltip.own.impl.WrappedTooltipEngine;

@OnlyIn(value=Dist.CLIENT)
public class TooltipRenderEngine
implements IGuiOverlay {
    public HitResult.Type lastType;
    public BlockPos lastPos;
    public UUID lastEntity;
    public GuiTooltip lastTooltip;

    public void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.m_91087_();
        HitResult res = mc.f_91077_;
        if (res != null) {
            EntityHitResult ehr;
            ClientLevel wc;
            if (res.m_6662_() == HitResult.Type.BLOCK && res instanceof BlockHitResult) {
                boolean diffPos;
                ITooltipTile t;
                BlockHitResult bhr = (BlockHitResult)res;
                wc = mc.f_91073_;
                BlockPos bp = bhr.m_82425_();
                Block bl = wc.m_8055_(bp).m_60734_();
                BlockEntity tl = wc.m_7702_(bp);
                ITooltipProvider prov = null;
                if (tl instanceof ITooltipProvider) {
                    ITooltipProvider t2;
                    prov = t2 = (ITooltipProvider)tl;
                } else if (bl instanceof ITooltipProvider) {
                    ITooltipProvider t3;
                    prov = t3 = (ITooltipProvider)bl;
                } else if (tl instanceof ITooltipTile && (t = (ITooltipTile)tl).isEngineSupported(EnumTooltipEngine.HAMMER_LIB)) {
                    prov = new WrappedTooltipEngine(tl, t);
                }
                boolean bl2 = diffPos = !Objects.equals(bp, this.lastPos);
                if (diffPos) {
                    this.lastPos = bp;
                    this.lastTooltip = null;
                }
                if (prov != null && (this.lastType != res.m_6662_() || diffPos || this.lastTooltip == null || this.lastTooltip.isDirty())) {
                    prov.setTooltipDirty(false);
                    this.lastTooltip = new GuiTooltip().withPlayer((Player)mc.f_91074_).withLocation((Level)wc, bp).withProvider(prov);
                }
                this.lastType = res.m_6662_();
            } else if (res.m_6662_() == HitResult.Type.ENTITY && res instanceof EntityHitResult && (wc = (ehr = (EntityHitResult)res).m_82443_()) instanceof ITooltipProvider) {
                boolean diffEntity;
                ITooltipProvider prov = (ITooltipProvider)wc;
                Entity ent = ehr.m_82443_();
                boolean bl = diffEntity = !Objects.equals(ent.m_20148_(), this.lastEntity);
                if (diffEntity) {
                    this.lastEntity = ent.m_20148_();
                    this.lastTooltip = null;
                }
                if (diffEntity && (this.lastType != res.m_6662_() || prov.isTooltipDirty() || this.lastTooltip == null || this.lastTooltip.isDirty())) {
                    prov.setTooltipDirty(false);
                    this.lastTooltip = new GuiTooltip().withPlayer((Player)mc.f_91074_).withEntity(ent).withProvider(prov);
                }
                this.lastType = res.m_6662_();
            } else {
                this.lastPos = null;
                this.lastTooltip = null;
            }
        } else {
            this.lastPos = null;
            this.lastTooltip = null;
        }
        if (this.lastTooltip != null) {
            Window window = gui.getMinecraft().f_90990_;
            int sw = window.m_85445_();
            int sh = window.m_85446_();
            float cx = (float)sw / 2.0f + 12.0f;
            float cy = ((float)sh - this.lastTooltip.getHeight()) / 2.0f + 2.0f;
            this.lastTooltip.render(poseStack, cx, cy, partialTick);
        }
    }
}

