/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.function.IntPredicate;

public class StringReader {
    public static String readUntilWhitespace(BufferedReader reader) throws IOException {
        int r;
        int read = 1;
        reader.mark(read);
        StringBuilder sb = new StringBuilder();
        while ((r = reader.read()) >= 0) {
            reader.reset();
            reader.mark(++read);
            reader.skip(read - 1);
            if (Character.isWhitespace((char)r)) {
                if (sb.length() <= 0) continue;
                return sb.toString();
            }
            sb.append((char)r);
        }
        return sb.toString();
    }

    public static String readName(BufferedReader reader, IntPredicate whitespaceFilter) throws IOException {
        return StringReader.readName(reader, false, whitespaceFilter);
    }

    public static String readName(BufferedReader reader, boolean forceEscaping, IntPredicate whitespaceFilter) throws IOException {
        int r;
        boolean escaping;
        reader.mark(1);
        boolean bl = escaping = StringReader.skipWhitespaces(reader) == 34 || forceEscaping;
        if (!escaping) {
            reader.reset();
        }
        boolean isInBackslashState = false;
        StringBuilder sb = new StringBuilder();
        while ((r = reader.read()) >= 0) {
            if (escaping) {
                if (isInBackslashState) {
                    if (r == 110) {
                        sb.append('\n');
                    } else if (r == 116) {
                        sb.append('\t');
                    } else {
                        sb.append((char)r);
                    }
                    isInBackslashState = false;
                    continue;
                }
                if (r == 92) {
                    isInBackslashState = true;
                    continue;
                }
                if (r == 34) {
                    reader.mark(1);
                    break;
                }
                sb.append((char)r);
            } else {
                if (whitespaceFilter.test(r)) {
                    if (sb.length() <= 0) continue;
                    return sb.toString();
                }
                sb.append((char)r);
            }
            reader.mark(1);
        }
        return sb.toString();
    }

    public static int skipWhitespaces(BufferedReader reader) throws IOException {
        int r;
        reader.mark(4);
        while ((r = reader.read()) >= 0 && Character.isWhitespace((char)r)) {
            reader.mark(4);
        }
        return r;
    }

    public static void writeName(BufferedWriter writer, String name, IntPredicate whitespace) throws IOException {
        writer.write(34);
        for (char c : name.toCharArray()) {
            if (c == '\"' || c == '\\') {
                writer.write(92);
            } else {
                if (c == '\n') {
                    writer.write("\\n");
                    continue;
                }
                if (c == '\r') continue;
                if (c == '\t') {
                    writer.write("\\t");
                    continue;
                }
            }
            writer.write(c);
        }
        writer.write(34);
    }
}

