/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.io.buf;

import java.nio.ByteBuffer;
import org.zeith.hammerlib.util.configured.io.buf.IByteBuf;

public class NioByteBuf
implements IByteBuf {
    protected final ByteBuffer buffer;

    public NioByteBuf(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void writeByte(int b) {
        this.buffer.put((byte)b);
    }

    @Override
    public void writeShort(int s) {
        this.buffer.putShort((short)s);
    }

    @Override
    public void writeInt(int i) {
        this.buffer.putInt(i);
    }

    @Override
    public void writeLong(long l) {
        this.buffer.putLong(l);
    }

    @Override
    public void writeFloat(float f) {
        this.buffer.putFloat(f);
    }

    @Override
    public void writeDouble(double d) {
        this.buffer.putDouble(d);
    }

    @Override
    public void writeBytes(byte[] bytes, int off, int len) {
        this.buffer.put(bytes, off, len);
    }

    @Override
    public byte readByte() {
        return this.buffer.get();
    }

    @Override
    public short readShort() {
        return this.buffer.getShort();
    }

    @Override
    public int readInt() {
        return this.buffer.getInt();
    }

    @Override
    public long readLong() {
        return this.buffer.getLong();
    }

    @Override
    public float readFloat() {
        return this.buffer.getFloat();
    }

    @Override
    public double readDouble() {
        return this.buffer.getDouble();
    }

    @Override
    public int readBytes(byte[] buf, int off, int length) {
        length = Math.min(length, this.buffer.limit() - this.buffer.position());
        this.buffer.get(buf, off, length);
        return length;
    }
}

