/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.utils;

import blusunrize.immersiveengineering.api.utils.Raytracer;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.CatenaryTracer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableDouble;

public class WireUtils {
    public static Connection getConnectionMovedThrough(Level world, LivingEntity e) {
        Vec3 start = e.m_20299_(0.0f);
        Vec3 end = e.m_20299_(1.0f);
        return WireUtils.raytraceWires(world, start, end, null);
    }

    public static Connection raytraceWires(Level world, Vec3 start, Vec3 end, @Nullable Connection ignored) {
        GlobalWireNetwork global = GlobalWireNetwork.getNetwork(world);
        WireCollisionData collisionData = global.getCollisionData();
        AtomicReference ret = new AtomicReference();
        MutableDouble minDistSq = new MutableDouble(Double.POSITIVE_INFINITY);
        Raytracer.rayTrace(start, end, world, pos -> {
            Collection<WireCollisionData.CollisionInfo> infoAtPos = collisionData.getCollisionInfo((BlockPos)pos);
            for (WireCollisionData.CollisionInfo wireInfo : infoAtPos) {
                Connection c = wireInfo.connection();
                if (c.equals(ignored)) continue;
                Vec3 startRelative = start.m_82520_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
                Vec3 across = wireInfo.intersectB().m_82546_(wireInfo.intersectA());
                double t = WireUtils.getCoeffForMinDistance(startRelative, wireInfo.intersectA(), across);
                t = Mth.m_14008_((double)t, (double)0.0, (double)1.0);
                Vec3 closest = wireInfo.intersectA().m_82520_(t * across.f_82479_, t * across.f_82480_, t * across.f_82481_);
                double distSq = closest.m_82557_(startRelative);
                if (!(distSq < minDistSq.doubleValue())) continue;
                ret.set(c);
                minDistSq.setValue(distSq);
            }
        });
        return (Connection)ret.get();
    }

    public static boolean preventsConnection(Level worldIn, BlockPos pos, BlockState state, Vec3 a, Vec3 b) {
        VoxelShape shape = state.m_60812_((BlockGetter)worldIn, pos);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83144_(), (BooleanOp)BooleanOp.f_82689_);
        for (AABB aabb : shape.m_83299_()) {
            if (!(aabb = aabb.m_82400_(1.0E-5)).m_82390_(a) && !aabb.m_82390_(b) && !aabb.m_82371_(a, b).isPresent()) continue;
            return true;
        }
        return false;
    }

    public static Set<BlockPos> findObstructingBlocks(Level world, Connection conn, Set<BlockPos> ignore) {
        HashSet<BlockPos> obstructions = new HashSet<BlockPos>();
        WireUtils.raytraceAlongCatenary(conn, p -> {
            if (!ignore.contains(p.block())) {
                BlockState state = world.m_8055_(p.block());
                if (WireUtils.preventsConnection(world, p.block(), state, p.entersAt(), p.leavesAt())) {
                    obstructions.add(p.block());
                }
            }
        }, p -> {});
        return obstructions;
    }

    public static WireType getWireTypeFromNBT(CompoundTag tag, String key) {
        return WireType.getValue(tag.m_128461_(key));
    }

    public static void raytraceAlongCatenary(Connection conn, Consumer<BlockIntersection> in, Consumer<BlockIntersection> close) {
        BlockPos offset = conn.getEndA().position();
        CatenaryTracer ct = new CatenaryTracer(conn.getCatenaryData(), offset);
        ct.calculateIntegerIntersections();
        ct.forEachSegment(segment -> (segment.inBlock ? in : close).accept(new BlockIntersection(segment.mainPos, segment.relativeSegmentStart, segment.relativeSegmentEnd)));
    }

    public static Connection getTargetConnection(Level world, Player player, Connection ignored, double maxDistance) {
        Vec3 look = player.m_20154_();
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(look.m_82490_(maxDistance));
        return WireUtils.raytraceWires(world, start, end, ignored);
    }

    public static void moveConnectionEnd(Connection conn, ConnectionPoint currEnd, ConnectionPoint newEnd, Level world) {
        ConnectionPoint fixedPos = conn.getOtherEnd(currEnd);
        GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork(world);
        globalNet.removeConnection(conn);
        globalNet.addConnection(new Connection(conn.type, fixedPos, newEnd, globalNet));
    }

    public static double getCoeffForMinDistance(Vec3 point, Vec3 line, Vec3 across) {
        if (across.f_82479_ == 0.0 && across.f_82481_ == 0.0) {
            return (point.f_82480_ - line.f_82480_) / across.f_82480_;
        }
        Vec3 delta = point.m_82546_(line);
        return delta.m_82526_(across) / across.m_82556_();
    }

    public static boolean hasAnyConnections(GlobalWireNetwork global, IImmersiveConnectable iic) {
        for (ConnectionPoint cp : iic.getConnectionPoints()) {
            LocalWireNetwork local = global.getNullableLocalNet(cp);
            if (local == null || local.getConnections(cp).stream().allMatch(Connection::isInternal)) continue;
            return true;
        }
        return false;
    }

    public static Vec3 loadVec3(Tag loadFrom) {
        if (!(loadFrom instanceof ListTag)) {
            return Vec3.f_82478_;
        }
        ListTag list = (ListTag)loadFrom;
        return new Vec3(list.m_128772_(0), list.m_128772_(1), list.m_128772_(2));
    }

    public static Tag storeVec3(Vec3 vec) {
        ListTag list = new ListTag();
        list.add((Object)DoubleTag.m_128500_((double)vec.f_82479_));
        list.add((Object)DoubleTag.m_128500_((double)vec.f_82480_));
        list.add((Object)DoubleTag.m_128500_((double)vec.f_82481_));
        return list;
    }

    public static Vec3 getConnectionOffset(GlobalWireNetwork globalNet, ConnectionPoint here, ConnectionPoint other, WireType type) {
        return globalNet.getLocalNet(here).getConnector(here).getConnectionOffset(here, other, type);
    }

    public static void forEachRenderPoint(Connection conn, RenderPointConsumer out) {
        BlockPos origin = conn.getEndA().position();
        for (int i = 0; i <= 16; ++i) {
            Vec3 relativePos = conn.getCatenaryData().getRenderPoint(i);
            BlockPos containingBlock = origin.m_7637_(relativePos.f_82479_, relativePos.f_82480_, relativePos.f_82481_);
            SectionPos section = SectionPos.m_123199_((BlockPos)containingBlock);
            out.accept(i, relativePos, section);
        }
    }

    public static interface RenderPointConsumer {
        public void accept(int var1, Vec3 var2, SectionPos var3);
    }

    public record BlockIntersection(BlockPos block, Vec3 entersAt, Vec3 leavesAt) {
    }
}

