/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.energy.IMutableEnergyStorage;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.metal.MixerBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class MixerMenu
extends IEContainerMenu
implements IESlot.ICallbackContainer {
    public final IEnergyStorage energy;
    public final GetterAndSetter<List<SlotProgress>> progress;
    public final GetterAndSetter<List<FluidStack>> tankContents;
    public final GetterAndSetter<Boolean> outputAll;

    public static MixerMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, MixerBlockEntity be) {
        GetterAndSetter<List<SlotProgress>> progress = GetterAndSetter.getterOnly(() -> {
            ArrayList<SlotProgress> result = new ArrayList<SlotProgress>();
            for (MultiblockProcess process : be.processQueue) {
                if (!(process instanceof MultiblockProcessInMachine)) continue;
                MultiblockProcessInMachine inMachine = (MultiblockProcessInMachine)process;
                float mod = 1.0f - (float)process.processTick / (float)process.getMaxTicks(be.m_58904_());
                for (int inputSlot : inMachine.getInputSlots()) {
                    result.add(new SlotProgress(inputSlot, mod));
                }
            }
            return result;
        });
        return new MixerMenu(MixerMenu.blockCtx(type, id, be), invPlayer, (IItemHandler)new ItemStackHandler(be.inventory), be.energyStorage, progress, GetterAndSetter.getterOnly(() -> be.tank.fluids), new GetterAndSetter<Boolean>(() -> be.outputAll, b -> {
            be.outputAll = b;
        }));
    }

    public static MixerMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        return new MixerMenu(MixerMenu.clientCtx(type, id), invPlayer, (IItemHandler)new ItemStackHandler(8), new MutableEnergyStorage(16000), GetterAndSetter.standalone(List.of()), GetterAndSetter.standalone(List.of()), GetterAndSetter.standalone(false));
    }

    private MixerMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, IItemHandler inv, IMutableEnergyStorage energy, GetterAndSetter<List<SlotProgress>> progress, GetterAndSetter<List<FluidStack>> tankContents, GetterAndSetter<Boolean> outputAll) {
        super(ctx);
        int i;
        this.energy = energy;
        this.progress = progress;
        this.tankContents = tankContents;
        this.outputAll = outputAll;
        for (i = 0; i < 8; ++i) {
            this.m_38897_((Slot)new IESlot.ContainerCallback(this, inv, i, 7 + i % 2 * 21, 7 + i / 2 * 18));
        }
        this.ownSlotCount = 8;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 86 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 144));
        }
        this.addGenericData(GenericContainerData.energy(energy));
        this.addGenericData(new GenericContainerData<List<SlotProgress>>(GenericDataSerializers.MIXER_SLOTS, progress));
        this.addGenericData(new GenericContainerData<List<FluidStack>>(GenericDataSerializers.FLUID_STACKS, tankContents));
        this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, outputAll));
    }

    @Override
    public boolean canInsert(ItemStack stack, int slotNumber, Slot slotObject) {
        for (SlotProgress progress : this.progress.get()) {
            if (progress.slot != slotNumber) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canTake(ItemStack stack, int slotNumber, Slot slotObject) {
        return this.canInsert(stack, slotNumber, slotObject);
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag nbt) {
        if (nbt.m_128425_("outputAll", 1)) {
            this.outputAll.set(nbt.m_128471_("outputAll"));
        }
    }

    public record SlotProgress(int slot, float progress) {
        public SlotProgress(FriendlyByteBuf buf) {
            this(buf.m_130242_(), buf.readFloat());
        }

        public static void write(FriendlyByteBuf buf, SlotProgress progress) {
            buf.m_130130_(progress.slot).writeFloat(progress.progress);
        }
    }
}

