/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.common.Tags;

public class SurveyToolsItem
extends IEBaseItem {
    private static final List<BiPredicate<Level, BlockPos>> CAN_USE_ON = new ArrayList<BiPredicate<Level, BlockPos>>();
    private static final String DATA_KEY = "veinData";

    public SurveyToolsItem() {
        super(new Item.Properties().m_41487_(1).m_41499_(300));
        CAN_USE_ON.add((world, pos) -> {
            BlockState state = world.m_8055_(pos);
            return state.m_60767_() == Material.f_76313_ || state.m_60767_() == Material.f_76314_ || state.m_60767_() == Material.f_76315_ || state.m_60767_() == Material.f_76317_;
        });
        CAN_USE_ON.add((world, pos) -> world.m_8055_(pos).m_204336_(Tags.Blocks.STONE));
        CAN_USE_ON.add((world, pos) -> {
            Block block = world.m_8055_(pos).m_60734_();
            return block == Blocks.f_50730_ || block == Blocks.f_50137_;
        });
        CAN_USE_ON.add((world, pos) -> {
            BlockState state = world.m_8055_(pos);
            return state.m_60767_() == Material.f_76278_ && (double)state.m_60800_((BlockGetter)world, pos) < 0.5;
        });
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 50;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (!CAN_USE_ON.stream().anyMatch(predicate -> predicate.test(world, pos))) {
            player.m_5661_((Component)Component.m_237115_((String)"chat.immersiveengineering.info.survey.wrong_block"), true);
            return InteractionResult.FAIL;
        }
        player.m_6672_(context.m_43724_());
        return InteractionResult.SUCCESS;
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entityLiving) {
        MutableComponent response;
        if (!(entityLiving instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer player = (ServerPlayer)entityLiving;
        BlockHitResult rtr = SurveyToolsItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockPos pos = rtr.m_82425_();
        MineralVein vein = ExcavatorHandler.getRandomMineral(world, pos);
        if (vein == null || vein.getMineral(world) == null) {
            player.m_5661_((Component)Component.m_237115_((String)"chat.immersiveengineering.info.survey.no_vein"), true);
            return stack;
        }
        ListTag data = SurveyToolsItem.getVeinData(stack, (ResourceKey<Level>)world.m_46472_(), vein.getPos());
        int dataCount = data.size();
        boolean tooClose = data.stream().anyMatch(inbt -> {
            int dZ;
            int dX = ((CompoundTag)inbt).m_128451_("x") - pos.m_123341_();
            return dX * dX + (dZ = ((CompoundTag)inbt).m_128451_("z") - pos.m_123343_()) * dZ < 16;
        });
        if (tooClose) {
            player.m_5661_((Component)Component.m_237115_((String)"chat.immersiveengineering.info.survey.too_close"), true);
            return stack;
        }
        Vec2 vecToCenter = new Vec2((float)(vein.getPos().f_140723_() - pos.m_123341_()), (float)(vein.getPos().f_140724_() - pos.m_123343_()));
        if (vecToCenter.f_82470_ == 0.0f && vecToCenter.f_82471_ == 0.0f) {
            response = Component.m_237110_((String)"chat.immersiveengineering.info.survey.hint.center", (Object[])new Object[]{Component.m_237115_((String)vein.getMineral(world).getTranslationKey())});
        } else {
            double angle = Math.toDegrees(Math.atan2(vecToCenter.f_82471_, vecToCenter.f_82470_));
            int segment = (int)((angle + 270.0) % 360.0 / 45.0);
            switch (dataCount) {
                case 0: {
                    response = Component.m_237110_((String)"chat.immersiveengineering.info.survey.hint.1", (Object[])new Object[]{Component.m_237115_((String)vein.getMineral(world).getTranslationKey())});
                    break;
                }
                case 1: {
                    response = Component.m_237110_((String)"chat.immersiveengineering.info.survey.hint.2", (Object[])new Object[]{Component.m_237115_((String)vein.getMineral(world).getTranslationKey()), Component.m_237115_((String)("chat.immersiveengineering.info.survey.direction." + segment))});
                    break;
                }
                default: {
                    response = Component.m_237110_((String)"chat.immersiveengineering.info.survey.hint.3", (Object[])new Object[]{Component.m_237115_((String)vein.getMineral(world).getTranslationKey()), Math.round(Math.sqrt(vecToCenter.f_82470_ * vecToCenter.f_82470_ + vecToCenter.f_82471_ * vecToCenter.f_82471_)), Component.m_237115_((String)("chat.immersiveengineering.info.survey.direction." + segment))});
                }
            }
        }
        player.m_5661_((Component)response, false);
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("x", pos.m_123341_());
        tag.m_128405_("z", pos.m_123343_());
        tag.m_128359_("hint", Component.Serializer.m_130703_((Component)response));
        data.add((Object)tag);
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11713_, SoundSource.NEUTRAL, 1.0f, 1.0f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.4f);
        stack.m_41622_(1, (LivingEntity)player, user -> user.m_21190_(user.m_7655_()));
        return stack;
    }

    public static ListTag getVeinData(ItemStack surveyTools, ResourceKey<Level> dimension, ColumnPos veinPos) {
        ListTag list = surveyTools.m_41784_().m_128437_(DATA_KEY, 10);
        CompoundTag tag = null;
        String dimString = dimension.m_135782_().toString();
        for (Tag nbt : list) {
            CompoundTag tmp = (CompoundTag)nbt;
            if (!dimString.equals(tmp.m_128461_("dimension")) || tmp.m_128451_("x") != veinPos.f_140723_() || tmp.m_128451_("z") != veinPos.f_140724_()) continue;
            tag = tmp;
            break;
        }
        if (tag == null) {
            tag = new CompoundTag();
            tag.m_128359_("dimension", dimString);
            tag.m_128405_("x", veinPos.f_140723_());
            tag.m_128405_("z", veinPos.f_140724_());
            list.add((Object)tag);
            surveyTools.m_41784_().m_128365_(DATA_KEY, (Tag)list);
        }
        if (tag.m_128425_("data", 9)) {
            return tag.m_128437_("data", 10);
        }
        ListTag data = new ListTag();
        tag.m_128365_("data", (Tag)data);
        return data;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return false;
    }
}

