/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client;

import flaxbeard.immersivepetroleum.client.render.AutoLubricatorRenderer;
import flaxbeard.immersivepetroleum.client.render.DerrickRenderer;
import flaxbeard.immersivepetroleum.client.render.MotorboatRenderer;
import flaxbeard.immersivepetroleum.client.render.MultiblockDistillationTowerRenderer;
import flaxbeard.immersivepetroleum.client.render.MultiblockPumpjackRenderer;
import flaxbeard.immersivepetroleum.client.render.OilTankRenderer;
import flaxbeard.immersivepetroleum.client.render.SeismicSurveyBarrelRenderer;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.entity.IPEntityTypes;
import java.util.function.Supplier;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientModBusEventHandlers {
    @SubscribeEvent
    public static void registerRenders(EntityRenderersEvent.RegisterRenderers ev) {
        ClientModBusEventHandlers.registerBERender(ev, IPTileTypes.TOWER.master(), MultiblockDistillationTowerRenderer::new);
        ClientModBusEventHandlers.registerBERender(ev, IPTileTypes.PUMP.master(), MultiblockPumpjackRenderer::new);
        ClientModBusEventHandlers.registerBERender(ev, IPTileTypes.OILTANK.master(), OilTankRenderer::new);
        ClientModBusEventHandlers.registerBERender(ev, IPTileTypes.DERRICK.master(), DerrickRenderer::new);
        ClientModBusEventHandlers.registerBERender(ev, (BlockEntityType)IPTileTypes.AUTOLUBE.get(), AutoLubricatorRenderer::new);
        ClientModBusEventHandlers.registerBERender(ev, (BlockEntityType)IPTileTypes.SEISMIC_SURVEY.get(), SeismicSurveyBarrelRenderer::new);
        ClientModBusEventHandlers.registerEntityRenderingHandler(ev, IPEntityTypes.MOTORBOAT, MotorboatRenderer::new);
        ClientModBusEventHandlers.registerEntityRenderingHandler(ev, IPEntityTypes.MOLOTOV, ThrownItemRenderer::new);
    }

    private static <T extends BlockEntity> void registerBERender(EntityRenderersEvent.RegisterRenderers ev, BlockEntityType<T> type, Supplier<BlockEntityRenderer<T>> factory) {
        ev.registerBlockEntityRenderer(type, ctx -> (BlockEntityRenderer)factory.get());
    }

    private static <T extends Entity, T2 extends T> void registerEntityRenderingHandler(EntityRenderersEvent.RegisterRenderers ev, Supplier<EntityType<T2>> type, EntityRendererProvider<T> renderer) {
        ev.registerEntityRenderer(type.get(), renderer);
    }
}

