/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd.util;

import com.unrealdinnerbone.jamd.JAMDRegistry;
import com.unrealdinnerbone.jamd.block.PortalBlock;
import com.unrealdinnerbone.jamd.block.PortalTileEntity;
import com.unrealdinnerbone.jamd.util.TeleportHelper;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class TelerportUtils {
    public static void teleport(Player playerEntity, ResourceKey<Level> toWorldKey, BlockPos blockPos) {
        ServerLevel toWorld = playerEntity.m_20194_().m_129880_(toWorldKey);
        if (toWorld != null) {
            TelerportUtils.findPortalLocation((Level)toWorld, blockPos).ifPresentOrElse(portalLocation -> {
                if (toWorld.m_8055_(portalLocation).m_60795_()) {
                    toWorld.m_46597_(portalLocation, ((PortalBlock)((Object)((Object)JAMDRegistry.MINE_PORTAL_BLOCK.get()))).m_49966_());
                }
                TeleportHelper.teleport(playerEntity, toWorld, (double)portalLocation.m_123341_() + 0.5, portalLocation.m_123342_() + 1, (double)portalLocation.m_123343_() + 0.5);
            }, () -> playerEntity.m_5661_((Component)Component.m_237115_((String)"jamd.invalid.pos"), true));
        } else {
            playerEntity.m_5661_((Component)Component.m_237110_((String)"jamd.invalid.world", (Object[])new Object[]{toWorldKey.m_135782_().toString()}), true);
        }
    }

    private static Optional<BlockPos> findPortalLocation(Level worldTo, BlockPos fromPos) {
        if (worldTo.m_8055_(fromPos).m_60734_() == JAMDRegistry.MINE_PORTAL_BLOCK.get() && TelerportUtils.isSafeSpawnLocation(worldTo, fromPos)) {
            return Optional.of(fromPos.m_7494_());
        }
        int range = 5;
        return Optional.ofNullable(ChunkPos.m_45596_((ChunkPos)worldTo.m_46745_(fromPos).m_7697_(), (int)range).map(chunkPos -> worldTo.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_).m_5928_()).flatMap(Collection::stream).toList().stream().filter(pos -> worldTo.m_7702_(pos) instanceof PortalTileEntity).findFirst().orElseGet(() -> {
            int y;
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(0, 0, 0);
            int minY = worldTo.m_141937_();
            int maxY = worldTo.m_151558_();
            int start = worldTo.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, fromPos.m_123341_(), fromPos.m_123343_());
            for (y = start - 1; y > minY; --y) {
                if (!TelerportUtils.forLocationAround(worldTo, mutableBlockPos, fromPos.m_123341_(), fromPos.m_123343_(), y)) continue;
                return mutableBlockPos;
            }
            for (y = start; y < maxY; ++y) {
                if (!TelerportUtils.forLocationAround(worldTo, mutableBlockPos, fromPos.m_123341_(), fromPos.m_123343_(), y)) continue;
                return mutableBlockPos;
            }
            return null;
        }));
    }

    private static boolean forLocationAround(Level levelTo, BlockPos.MutableBlockPos blockPos, int fromX, int fromZ, int y) {
        for (int x = fromX - 6; x < fromX + 6; ++x) {
            for (int z = fromZ - 6; z < fromZ + 6; ++z) {
                blockPos.m_122178_(x, y, z);
                if (!TelerportUtils.isSaveLocation(levelTo, blockPos)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSaveLocation(Level levelTo, BlockPos.MutableBlockPos blockPos) {
        BlockState blockState = levelTo.m_8055_((BlockPos)blockPos);
        return blockState.m_60795_() && TelerportUtils.isSafeSpawnLocation(levelTo, blockPos.m_7494_());
    }

    private static boolean isSafeSpawnLocation(Level world, BlockPos blockPos) {
        return world.m_8055_(blockPos).m_60795_() && world.m_8055_(blockPos.m_7494_()).m_60795_();
    }
}

