/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import giselle.jei_mekanism_multiblocks.client.gui.TextAlignment;
import giselle.jei_mekanism_multiblocks.common.JEI_MekanismMultiblocks;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GuiHelper {
    public static final ResourceLocation WIDGETS_LOCATION = JEI_MekanismMultiblocks.rl("textures/gui/widgets.png");

    public static void renderComponentTooltip(PoseStack pPoseStack, int pMouseX, int pMouseY, Component ... tooltip) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ != null && tooltip.length > 0) {
            minecraft.f_91080_.m_96597_(pPoseStack, Arrays.asList(tooltip), pMouseX, pMouseY);
        }
    }

    public static void renderComponentTooltip(PoseStack pPoseStack, int pMouseX, int pMouseY, List<Component> tooltip) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ != null && tooltip.size() > 0) {
            minecraft.f_91080_.m_96597_(pPoseStack, tooltip, pMouseX, pMouseY);
        }
    }

    public static void fillRectagleBlack(PoseStack pPoseStack, int x, int y, int width, int height) {
        GuiComponent.m_93172_((PoseStack)pPoseStack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)-16777216);
    }

    public static void fillRectagle(PoseStack pPoseStack, int x, int y, int width, int height, float r, float g, float b, float a) {
        int color = Mth.m_14159_((float)r, (float)g, (float)b) | Mth.m_14143_((float)(255.0f * a)) << 24;
        GuiComponent.m_93172_((PoseStack)pPoseStack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
    }

    public static void drawScaledText(PoseStack pPoseStack, Component text, int x, int y, int width, int color, boolean shadow) {
        GuiHelper.drawScaledText(pPoseStack, text, x, y, width, color, shadow, TextAlignment.LEFT);
    }

    public static void drawScaledText(PoseStack pPoseStack, Component text, int x, int y, int width, int color, boolean shadow, TextAlignment alignment) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        int textWidth = font.m_92852_((FormattedText)text);
        float scale = Math.min((float)width / (float)textWidth, 1.0f);
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(scale, scale, 1.0f);
        float scaledX = ((float)x + (float)alignment.align(width, (float)textWidth * scale)) / scale;
        float f = (float)y / scale;
        Objects.requireNonNull(font);
        float scaledY = f + (1.0f - scale) * 9.0f;
        if (shadow) {
            font.m_92763_(pPoseStack, text, scaledX, scaledY, color);
        } else {
            font.m_92889_(pPoseStack, text, scaledX, scaledY, color);
        }
        pPoseStack.m_85849_();
    }

    public static void blitButton(PoseStack pPoseStack, int x, int y, int width, int height, boolean active, boolean hovered) {
        int i = active ? (hovered ? 2 : 1) : 0;
        RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
        GuiHelper.blit9Patch(pPoseStack, x, y, width, height, i * 20, 52, 20, 20, 2, 2, 2, 2);
    }

    public static void blit9Patch(PoseStack pPoseStack, int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH, int uL, int vT, int uR, int vB) {
        GuiHelper.blit9Patch(pPoseStack, x, y, width, height, textureX, textureY, textureW, textureH, uL, vT, uR, vB, 256, 256);
    }

    public static void blit9Patch(PoseStack pPoseStack, int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH, int uL, int vT, int uR, int vB, int textureWidth, int textureHeight) {
        uL = Math.min(uL, width / 2);
        uR = Math.min(uR, width / 2);
        vT = Math.min(vT, height / 2);
        vB = Math.min(vB, height / 2);
        int inL = x + uL;
        int inR = x + width - uR;
        int inT = y + vT;
        int inB = y + height - vB;
        int inW = width - uL - uR;
        int inH = height - vT - vB;
        int textureInL = textureX + uL;
        int textureInR = textureX + textureW - uR;
        int textureInT = textureY + vT;
        int textureInB = textureY + textureH - vB;
        int textureInW = textureInR - textureInL;
        int textureInH = textureInB - textureInT;
        GuiComponent.m_93160_((PoseStack)pPoseStack, (int)x, (int)y, (int)uL, (int)vT, (float)textureX, (float)textureY, (int)uL, (int)vT, (int)textureWidth, (int)textureHeight);
        GuiComponent.m_93160_((PoseStack)pPoseStack, (int)inR, (int)y, (int)uR, (int)vT, (float)textureInR, (float)textureY, (int)uR, (int)vT, (int)textureWidth, (int)textureHeight);
        GuiComponent.m_93160_((PoseStack)pPoseStack, (int)x, (int)inB, (int)uL, (int)vB, (float)textureX, (float)textureInB, (int)uL, (int)vB, (int)textureWidth, (int)textureHeight);
        GuiComponent.m_93160_((PoseStack)pPoseStack, (int)inR, (int)inB, (int)uR, (int)vB, (float)textureInR, (float)textureInB, (int)uR, (int)vB, (int)textureWidth, (int)textureHeight);
        GuiComponent.m_93160_((PoseStack)pPoseStack, (int)inL, (int)y, (int)inW, (int)vT, (float)textureInL, (float)textureY, (int)textureInW, (int)vT, (int)textureWidth, (int)textureHeight);
        GuiComponent.m_93160_((PoseStack)pPoseStack, (int)inR, (int)inT, (int)uR, (int)inH, (float)textureInR, (float)textureInT, (int)uR, (int)textureInH, (int)textureWidth, (int)textureHeight);
        GuiComponent.m_93160_((PoseStack)pPoseStack, (int)inL, (int)inB, (int)inW, (int)vT, (float)textureInL, (float)textureInB, (int)textureInW, (int)vB, (int)textureWidth, (int)textureHeight);
        GuiComponent.m_93160_((PoseStack)pPoseStack, (int)x, (int)inT, (int)uL, (int)inH, (float)textureX, (float)textureInT, (int)uL, (int)textureInH, (int)textureWidth, (int)textureHeight);
        GuiComponent.m_93160_((PoseStack)pPoseStack, (int)inL, (int)inT, (int)inW, (int)inH, (float)textureInL, (float)textureInT, (int)textureInW, (int)textureInH, (int)textureWidth, (int)textureHeight);
    }

    private GuiHelper() {
    }
}

