/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.jei.category;

import giselle.jei_mekanism_multiblocks.client.gui.CheckBoxWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWithButtons;
import giselle.jei_mekanism_multiblocks.client.gui.Mod2IntSliderWidget;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockCategory;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockWidget;
import giselle.jei_mekanism_multiblocks.client.jei.ResultWidget;
import giselle.jei_mekanism_multiblocks.client.jei.category.ICostConsumer;
import giselle.jei_mekanism_multiblocks.common.util.VolumeTextHelper;
import java.util.List;
import java.util.function.Consumer;
import mekanism.api.chemical.ChemicalTags;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IChemicalProvider;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.common.GeneratorTags;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsItems;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.tags.ITagManager;

public class FusionReactorCategory
extends MultiblockCategory<FusionReactorCategoryWidget> {
    public FusionReactorCategory(IGuiHelper helper) {
        super(helper, MekanismGenerators.rl((String)"fusion_reactor"), FusionReactorCategoryWidget.class, (Component)GeneratorsLang.FUSION_REACTOR.translate(new Object[0]), GeneratorsBlocks.FUSION_REACTOR_CONTROLLER.getItemStack());
    }

    @Override
    protected void getRecipeCatalystItemStacks(Consumer<ItemStack> consumer) {
        super.getRecipeCatalystItemStacks(consumer);
        consumer.accept(GeneratorsBlocks.FUSION_REACTOR_CONTROLLER.getItemStack());
        consumer.accept(GeneratorsBlocks.FUSION_REACTOR_FRAME.getItemStack());
        consumer.accept(GeneratorsBlocks.FUSION_REACTOR_PORT.getItemStack());
        consumer.accept(GeneratorsBlocks.FUSION_REACTOR_LOGIC_ADAPTER.getItemStack());
        consumer.accept(GeneratorsBlocks.LASER_FOCUS_MATRIX.getItemStack());
        consumer.accept(GeneratorsBlocks.REACTOR_GLASS.getItemStack());
        List fusionFuelGases = ((ITagManager)ChemicalTags.GAS.getManager().get()).getTag(GeneratorTags.Gases.FUSION_FUEL).stream().toList();
        if (fusionFuelGases.size() > 0) {
            Gas fusionFuelGas = (Gas)fusionFuelGases.get(0);
            long capacity = MekanismGeneratorsConfig.generators.hohlraumMaxGas.get();
            consumer.accept(ChemicalUtil.getFilledVariant((ItemStack)GeneratorsItems.HOHLRAUM.getItemStack(), (long)capacity, (IChemicalProvider)fusionFuelGas));
        } else {
            consumer.accept(GeneratorsItems.HOHLRAUM.getItemStack());
        }
    }

    public static class FusionReactorCategoryWidget
    extends MultiblockWidget {
        protected CheckBoxWidget useReactorGlassCheckBox;
        protected CheckBoxWidget waterCooledCheckBox;
        protected IntSliderWithButtons portsWidget;
        protected IntSliderWithButtons logicAdaptersWidget;
        protected IntSliderWithButtons injectionRateWidget;

        @Override
        protected void collectOtherConfigs(Consumer<AbstractWidget> consumer) {
            super.collectOtherConfigs(consumer);
            this.useReactorGlassCheckBox = new CheckBoxWidget(0, 0, 0, 0, (Component)Component.m_237110_((String)"text.jei_mekanism_multiblocks.specs.use_things", (Object[])new Object[]{GeneratorsBlocks.REACTOR_GLASS.getItemStack().m_41786_()}), true);
            consumer.accept((AbstractWidget)this.useReactorGlassCheckBox);
            this.useReactorGlassCheckBox.addSelectedChangedHandler(this::onUseReactorGlassChanged);
            this.waterCooledCheckBox = new CheckBoxWidget(0, 0, 0, 0, (Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.specs.water_cooled"), false);
            consumer.accept((AbstractWidget)this.waterCooledCheckBox);
            this.waterCooledCheckBox.addSelectedChangedHandler(this::onWaterCooledChanged);
            this.portsWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.ports", 0, 0, 0);
            consumer.accept(this.portsWidget);
            ((IntSliderWidget)((Object)this.portsWidget.getSlider())).addValueChangeHanlder(this::onPortsChanged);
            this.logicAdaptersWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.logic_adapters", 0, 0, 0);
            consumer.accept(this.logicAdaptersWidget);
            ((IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider())).addValueChangeHanlder(this::onLogicAdaptersChanged);
            this.injectionRateWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.injection_rate", new Mod2IntSliderWidget(0, 0, 0, 0, (Component)Component.m_237119_(), 2, 2, 1000, 1));
            consumer.accept(this.injectionRateWidget);
            ((IntSliderWidget)((Object)this.injectionRateWidget.getSlider())).addValueChangeHanlder(this::onInjectionRateChanged);
            this.updatePortsSliderLimit();
            this.updateInjectionRateInfoMessage();
        }

        @Override
        protected void onDimensionChanged() {
            super.onDimensionChanged();
            this.updatePortsSliderLimit();
        }

        @Override
        public int getCornerBlocks() {
            return 36;
        }

        @Override
        public int getSideBlocks() {
            return 28;
        }

        public void updatePortsSliderLimit() {
            IntSliderWidget portsSlider = (IntSliderWidget)((Object)this.portsWidget.getSlider());
            int minPorts = portsSlider.getMinValue();
            int ports = portsSlider.getValue();
            portsSlider.setMinValue(this.isWaterCooled() ? 4 : 2);
            portsSlider.setMaxValue(this.getSideBlocks());
            portsSlider.setValue(ports + (portsSlider.getMinValue() - minPorts));
            this.updateLogicAdaptersSliderLimit();
        }

        public void updateLogicAdaptersSliderLimit() {
            IntSliderWidget adaptersSlider = (IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider());
            int adapters = adaptersSlider.getValue();
            adaptersSlider.setMaxValue(this.getSideBlocks() - this.getPortCount());
            adaptersSlider.setValue(adapters);
        }

        protected void onPortsChanged(int ports) {
            this.updateLogicAdaptersSliderLimit();
            this.markNeedUpdate();
        }

        protected void onLogicAdaptersChanged(int logicAdapters) {
            this.markNeedUpdate();
        }

        protected void onUseReactorGlassChanged(boolean useReactorGlass) {
            this.markNeedUpdate();
        }

        protected void onInjectionRateChanged(int injectionRate) {
            this.markNeedUpdate();
            this.updateInjectionRateInfoMessage();
        }

        protected void onWaterCooledChanged(boolean waterCooled) {
            this.updatePortsSliderLimit();
            this.markNeedUpdate();
            this.updateInjectionRateInfoMessage();
        }

        public void updateInjectionRateInfoMessage() {
            if (this.isWaterCooled()) {
                int limitedInjectionRate = Math.min(this.getInjectionRate(), 98);
                MutableComponent tooltip = Component.m_237110_((String)"text.jei_mekanism_multiblocks.tooltip.need_set_injection_rate", (Object[])new Object[]{limitedInjectionRate});
                this.waterCooledCheckBox.setTooltip(new Component[]{tooltip});
                this.injectionRateWidget.setTooltip(new Component[]{tooltip});
            } else {
                this.waterCooledCheckBox.setTooltip(new Component[0]);
                this.injectionRateWidget.setTooltip(new Component[0]);
            }
        }

        @Override
        protected void collectCost(ICostConsumer consumer) {
            super.collectCost(consumer);
            int corners = this.getCornerBlocks();
            int sides = this.getSideBlocks();
            int ports = this.getPortCount();
            sides -= ports;
            int logicAdapter = this.getLogicAdapterCount();
            sides -= logicAdapter;
            int frames = 0;
            int reactorGlasses = 0;
            if (this.isUseReactorGlass()) {
                frames = corners;
                reactorGlasses = sides;
            } else {
                frames = corners + sides;
                reactorGlasses = 0;
            }
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.FUSION_REACTOR_CONTROLLER));
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.FUSION_REACTOR_FRAME, frames));
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.FUSION_REACTOR_PORT, ports));
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.FUSION_REACTOR_LOGIC_ADAPTER, logicAdapter));
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.LASER_FOCUS_MATRIX));
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.REACTOR_GLASS, reactorGlasses));
        }

        @Override
        protected void collectResult(Consumer<AbstractWidget> consumer) {
            super.collectResult(consumer);
            int injectionRate = this.getInjectionRate();
            int limitedInjectionRate = Math.min(injectionRate, 98);
            long waterTank = MekanismGeneratorsConfig.generators.fusionWaterPerInjection.get() * limitedInjectionRate;
            long steamTank = MekanismGeneratorsConfig.generators.fusionSteamPerInjection.get() * (long)limitedInjectionRate;
            long fuelTank = MekanismGeneratorsConfig.generators.fusionFuelCapacity.get();
            FloatingLong energyFusionFuel = (FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get();
            double casingThermalConductivity = MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get();
            double casingTemp = energyFusionFuel.multiply((long)injectionRate).divide(casingThermalConductivity).doubleValue();
            long steamProduction = 0L;
            if (this.isWaterCooled()) {
                double waterHeatingRatio = MekanismGeneratorsConfig.generators.fusionWaterHeatingRatio.get();
                double wateredCasingTemp = energyFusionFuel.multiply((long)injectionRate).divide(casingThermalConductivity + waterHeatingRatio).doubleValue();
                double waterHeat = waterHeatingRatio * wateredCasingTemp;
                steamProduction = (long)(HeatUtils.getSteamEnergyEfficiency() * waterHeat / HeatUtils.getWaterThermalEnthalpy());
                steamProduction = Math.min(steamProduction, waterTank);
                double coolingHeat = (double)steamProduction / HeatUtils.getSteamEnergyEfficiency() * HeatUtils.getWaterThermalEnthalpy();
                double coolingCasingTemp = coolingHeat / casingThermalConductivity;
                casingTemp -= coolingCasingTemp;
            }
            double fusionThermocoupleEfficiency = MekanismGeneratorsConfig.generators.fusionThermocoupleEfficiency.get();
            FloatingLong passiveGeneration = FloatingLong.create((double)(fusionThermocoupleEfficiency * casingThermalConductivity * casingTemp));
            consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.passive_generation"), EnergyDisplay.of((FloatingLong)passiveGeneration).getTextComponent()));
            if (steamProduction > 0L) {
                consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.steam_production"), VolumeTextHelper.formatMBt(steamProduction)));
            }
            consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.fuel_tank"), VolumeTextHelper.formatMB(fuelTank)));
            if (this.isWaterCooled()) {
                MutableComponent injectionRateTooltip = Component.m_237110_((String)"text.jei_mekanism_multiblocks.tooltip.need_set_injection_rate", (Object[])new Object[]{limitedInjectionRate});
                ResultWidget watTankWidget = new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.water_tank"), VolumeTextHelper.formatMB(waterTank));
                watTankWidget.setTooltip(new Component[]{injectionRateTooltip});
                consumer.accept(watTankWidget);
                ResultWidget steamTankWidget = new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.steam_tank"), VolumeTextHelper.formatMB(steamTank));
                steamTankWidget.setTooltip(new Component[]{injectionRateTooltip});
                consumer.accept(steamTankWidget);
            }
            consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.energy_capacity"), EnergyDisplay.of((FloatingLong)((FloatingLong)MekanismGeneratorsConfig.generators.fusionEnergyCapacity.get())).getTextComponent()));
        }

        public int getPortCount() {
            return ((IntSliderWidget)((Object)this.portsWidget.getSlider())).getValue();
        }

        public void setPortCount(int portCount) {
            ((IntSliderWidget)((Object)this.portsWidget.getSlider())).setValue(portCount);
        }

        public int getLogicAdapterCount() {
            return ((IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider())).getValue();
        }

        public void setLogicAdapterCount(int logicAdapterCount) {
            ((IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider())).setValue(logicAdapterCount);
        }

        public boolean isUseReactorGlass() {
            return this.useReactorGlassCheckBox.isSelected();
        }

        public void setUseReactorGlass(boolean useReactorGlass) {
            this.useReactorGlassCheckBox.setSelected(useReactorGlass);
        }

        public int getInjectionRate() {
            return ((IntSliderWidget)((Object)this.injectionRateWidget.getSlider())).getValue();
        }

        public void setInjectionRate(int injectionRate) {
            ((IntSliderWidget)((Object)this.injectionRateWidget.getSlider())).setValue(injectionRate);
        }

        public boolean isWaterCooled() {
            return this.waterCooledCheckBox.isSelected();
        }

        public void setWaterCooled(boolean waterCooled) {
            this.waterCooledCheckBox.setSelected(waterCooled);
        }

        @Override
        public int getDimensionWidthMin() {
            return 5;
        }

        @Override
        public int getDimensionWidthMax() {
            return 5;
        }

        @Override
        public int getDimensionLengthMin() {
            return 5;
        }

        @Override
        public int getDimensionLengthMax() {
            return 5;
        }

        @Override
        public int getDimensionHeightMin() {
            return 5;
        }

        @Override
        public int getDimensionHeightMax() {
            return 5;
        }
    }
}

