/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.crafting;

import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class CraftingHelper2 {
    public static JsonObject serializeItemStack(ItemStack stack, boolean writeNBT) {
        JsonObject json = new JsonObject();
        json.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), "Can't serialize ItemStack: Item has no registry name: " + stack.m_41720_()).toString());
        json.addProperty("count", (Number)stack.m_41613_());
        if (writeNBT) {
            CompoundTag stackTag = stack.m_41782_() ? stack.m_41783_() : null;
            Tag capsTag = CraftingHelper2.forgeCaps(stack);
            if (stackTag != null || capsTag != null) {
                CompoundTag resultTag;
                CompoundTag compoundTag = resultTag = stackTag == null ? new CompoundTag() : stackTag.m_6426_();
                if (capsTag != null) {
                    resultTag.m_128365_("ForgeCaps", capsTag);
                }
                json.addProperty("nbt", resultTag.toString());
            }
        }
        return json;
    }

    @Nullable
    private static Tag forgeCaps(ItemStack stack) {
        CompoundTag cmp;
        Tag tag;
        CompoundTag nbt = stack.serializeNBT();
        if (!(!nbt.m_128441_("ForgeCaps") || (tag = nbt.m_128423_("ForgeCaps")) instanceof CompoundTag && (cmp = (CompoundTag)tag).m_128456_())) {
            return nbt.m_128423_("ForgeCaps");
        }
        return null;
    }
}

