/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.block_crushing;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.LycheeTags;
import snownee.lychee.block_crushing.BlockCrushingContext;
import snownee.lychee.block_crushing.BlockCrushingRecipe;
import snownee.lychee.block_crushing.LycheeFallingBlockEntity;
import snownee.lychee.core.input.ItemHolder;
import snownee.lychee.core.network.SCustomLevelEventPacket;
import snownee.lychee.core.recipe.type.BlockKeyRecipeType;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.util.CommonProxy;

public class BlockCrushingRecipeType
extends BlockKeyRecipeType<BlockCrushingContext, BlockCrushingRecipe> {
    private LycheeRecipeType.ValidItemCache validItems = new LycheeRecipeType.ValidItemCache();

    public BlockCrushingRecipeType(String name, Class<BlockCrushingRecipe> clazz, @Nullable LootContextParamSet paramSet) {
        super(name, clazz, paramSet);
        this.compactInputs = true;
    }

    public void process(FallingBlockEntity entity) {
        boolean matched;
        if (this.isEmpty()) {
            return;
        }
        BlockPos pos = CommonProxy.getOnPos((Entity)entity);
        BlockState fallingBlock = entity.m_31980_();
        Collection recipes = this.recipesByBlock.getOrDefault(fallingBlock.m_60734_(), Collections.EMPTY_LIST);
        if (recipes.isEmpty()) {
            return;
        }
        AABB box = entity.m_20191_();
        Level level = entity.f_19853_;
        BlockState landingBlock = level.m_8055_(pos);
        if (landingBlock.m_204336_(LycheeTags.EXTEND_BOX)) {
            box = box.m_82367_(new AABB(pos));
        }
        List itemEntities = entity.f_19853_.m_6443_(ItemEntity.class, box, $ -> $.m_6084_() && this.validItems.contains($.m_32055_()));
        BlockCrushingContext.Builder ctxBuilder = new BlockCrushingContext.Builder(entity.f_19853_, itemEntities, entity);
        ctxBuilder.withParameter(LootContextParams.f_81460_, entity.m_20182_());
        ctxBuilder.withParameter(LootContextParams.f_81455_, entity);
        ctxBuilder.withParameter(LootContextParams.f_81461_, landingBlock);
        ctxBuilder.withParameter(LycheeLootContextParams.BLOCK_POS, pos);
        BlockCrushingContext ctx = ctxBuilder.create(this.contextParamSet);
        boolean matchedAny = false;
        int loop = 0;
        block2: do {
            matched = false;
            for (BlockCrushingRecipe recipe : recipes) {
                if (recipe.ingredients.isEmpty() && loop > 0) continue;
                try {
                    int i;
                    Optional match = this.tryMatch(recipe, level, ctx);
                    if (!match.isPresent()) continue;
                    matched = true;
                    matchedAny = true;
                    int times = 1;
                    if (ctx.getMatch() != null && ctx.getMatch().inputUsed.length > 0) {
                        int[] inputUsed = ctx.getMatch().inputUsed;
                        times = recipe.getRandomRepeats(Integer.MAX_VALUE, ctx);
                        for (i = 0; i < inputUsed.length; ++i) {
                            if (inputUsed[i] <= 0) continue;
                            ItemStack stack = ((ItemEntity)ctx.filteredItems.get(i)).m_32055_();
                            times = Math.min(times, stack.m_41613_() / inputUsed[i]);
                        }
                    }
                    ((BlockCrushingRecipe)match.get()).applyPostActions(ctx, times);
                    if (!ctx.runtime.doDefault) {
                        ((LycheeFallingBlockEntity)entity).lychee$cancelDrop();
                    }
                    if (CommonProxy.hasKiwi) {
                        HashSet alreadySentParticles = Sets.newHashSet();
                        for (i = 0; i < ctx.itemHolders.size(); ++i) {
                            ItemHolder holder = ctx.itemHolders.get(i);
                            if (ctx.itemHolders.ignoreConsumptionFlags.get(i) || holder.get().m_41619_() || !(holder instanceof ItemHolder.InWorld) || alreadySentParticles.contains(holder)) continue;
                            alreadySentParticles.add(holder);
                            SCustomLevelEventPacket.sendItemParticles(holder.get(), ctx.getServerLevel(), ((ItemHolder.InWorld)holder).getEntity().m_20182_());
                        }
                    }
                    ctx.totalItems -= ctx.itemHolders.postApply(true, times);
                    if (recipe.getMaxRepeats().m_55327_()) {
                        ctx.filteredItems = null;
                        ctx.setMatch(null);
                        ctx.itemEntities.removeIf($ -> $.m_32055_().m_41619_());
                        continue;
                    }
                    break block2;
                }
                catch (Exception e) {
                    Lychee.LOGGER.error("", (Throwable)e);
                    break block2;
                }
            }
        } while (++loop < 100 && matched);
        if (matchedAny) {
            BlockState state = level.m_8055_(entity.m_20183_());
            if (!FallingBlock.m_53241_((BlockState)state)) {
                entity.m_20343_(entity.m_20185_(), (double)(pos.m_123342_() + 1), entity.m_20189_());
            }
            ((LycheeFallingBlockEntity)entity).lychee$matched();
            ctx.itemEntities.forEach($ -> $.m_32045_($.m_32055_().m_41777_()));
        }
    }

    @Override
    public void buildCache() {
        super.buildCache();
        this.validItems.buildCache(this.recipes);
    }
}

