/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.jei.category;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import snownee.lychee.client.core.post.PostActionRenderer;
import snownee.lychee.client.gui.AllGuiTextures;
import snownee.lychee.compat.IngredientInfo;
import snownee.lychee.compat.JEIREI;
import snownee.lychee.compat.jei.JEICompat;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.post.CompoundAction;
import snownee.lychee.core.post.DropItem;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.RandomSelect;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.util.ClientProxy;

public abstract class BaseJEICategory<C extends LycheeContext, T extends LycheeRecipe<C>>
implements IRecipeCategory<T> {
    public static final int width = 119;
    public static final int height = 59;
    public final List<LycheeRecipeType<C, T>> recipeTypes;
    public IDrawable icon;
    public List<T> initialRecipes;
    public RecipeType<T> recipeType;
    protected IDrawable bg;
    protected Rect2i infoRect;

    public BaseJEICategory(LycheeRecipeType<C, T> recipeType) {
        this(List.of(recipeType));
    }

    public BaseJEICategory(List<LycheeRecipeType<C, T>> recipeTypes) {
        this.recipeTypes = recipeTypes;
        this.infoRect = new Rect2i(0, 25, 8, 8);
    }

    public static void addBlockIngredients(IRecipeLayoutBuilder builder, LycheeRecipe<?> recipe) {
        BaseJEICategory.addBlockIngredients(builder, recipe.getBlockInputs(), RecipeIngredientRole.INPUT);
        BaseJEICategory.addBlockIngredients(builder, recipe.getBlockOutputs(), RecipeIngredientRole.OUTPUT);
    }

    public static void addBlockIngredients(IRecipeLayoutBuilder builder, Iterable<BlockPredicate> blocks, RecipeIngredientRole role) {
        for (BlockPredicate block : blocks) {
            List<ItemStack> items = BlockPredicateHelper.getMatchedItemStacks(block);
            Set<Fluid> fluids = BlockPredicateHelper.getMatchedFluids(block);
            if (items.isEmpty() && fluids.isEmpty()) continue;
            IIngredientAcceptor acceptor = builder.addInvisibleIngredients(role);
            acceptor.addItemStacks(items);
            fluids.forEach(fluid -> acceptor.addFluidStack(fluid, JEICompat.HELPERS.getPlatformFluidHelper().bucketVolume()));
        }
    }

    public static <T> void slotGroup(IRecipeLayoutBuilder builder, int x, int y, int startIndex, List<T> items, SlotLayoutFunction<T> layoutFunction) {
        int size = Math.min(items.size(), 9);
        int gridX = (int)Math.ceil(Math.sqrt(size));
        int gridY = (int)Math.ceil((float)size / (float)gridX);
        x -= gridX * 9;
        y -= gridY * 9;
        int index = 0;
        for (int i = 0; i < gridY; ++i) {
            for (int j = 0; j < gridX && index < size; ++index, ++j) {
                layoutFunction.apply(builder, items.get(index), startIndex + index, x + j * 19, y + i * 19);
            }
        }
    }

    public static void actionSlot(IRecipeLayoutBuilder builder, PostAction action, int index, int x, int y) {
        IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.OUTPUT, x + 1, y + 1);
        IdentityHashMap itemMap = Maps.newIdentityHashMap();
        BaseJEICategory.buildActionSlot(builder, action, itemMap, slot);
        slot.addTooltipCallback((view, tooltip) -> {
            List<Component> list;
            Optional optional = view.getDisplayedIngredient();
            if (optional.isEmpty()) {
                return;
            }
            ITypedIngredient ingr = (ITypedIngredient)optional.get();
            Object raw = ingr.getIngredient();
            if (!itemMap.containsKey(raw)) {
                return;
            }
            tooltip.clear();
            raw = itemMap.get(raw);
            if (action instanceof RandomSelect) {
                RandomSelect randomSelect = (RandomSelect)action;
                list = PostActionRenderer.getTooltipsFromRandom(randomSelect, (PostAction)raw);
            } else {
                list = PostActionRenderer.of(action).getTooltips(action);
            }
            tooltip.addAll(list);
        });
        slot.setBackground(JEICompat.slot(action.getConditions().isEmpty() ? JEICompat.SlotType.NORMAL : JEICompat.SlotType.CHANCE), -1, -1);
    }

    private static void buildActionSlot(IRecipeLayoutBuilder layout, PostAction action, Map<ItemStack, PostAction> itemMap, IRecipeSlotBuilder slot) {
        if (action instanceof DropItem) {
            DropItem dropitem = (DropItem)action;
            slot.addItemStack(dropitem.stack);
            itemMap.put(dropitem.stack, dropitem);
        } else if (action instanceof CompoundAction) {
            CompoundAction compoundAction = (CompoundAction)((Object)action);
            compoundAction.getChildActions().filter(Predicate.not(PostAction::isHidden)).forEach(child -> BaseJEICategory.buildActionSlot(layout, child, itemMap, slot));
        } else {
            slot.addIngredient(JEICompat.POST_ACTION, (Object)action);
            List<ItemStack> itemOutputs = action.getItemOutputs();
            if (!itemOutputs.isEmpty()) {
                layout.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStacks(itemOutputs);
            }
        }
    }

    public static void drawInfoBadge(ILycheeRecipe<?> recipe, PoseStack matrixStack, double mouseX, double mouseY, Rect2i rect) {
        if (BaseJEICategory.hasInfoBadge(recipe)) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)rect.m_110085_(), (double)rect.m_110086_(), 0.0);
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            AllGuiTextures.INFO.render(matrixStack, 0, 0);
            matrixStack.m_85849_();
        }
    }

    public static boolean hasInfoBadge(ILycheeRecipe<?> recipe) {
        return !recipe.getContextualHolder().getConditions().isEmpty() || !Strings.isNullOrEmpty((String)recipe.getComment());
    }

    public static List<Component> getTooltipStrings(ILycheeRecipe<?> recipe, double mouseX, double mouseY, Rect2i rect) {
        if (rect.m_110087_((int)mouseX, (int)mouseY)) {
            return JEIREI.getRecipeTooltip(recipe);
        }
        return List.of();
    }

    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    public ResourceLocation getRegistryName(T recipe) {
        return ((LycheeRecipe)recipe).m_6423_();
    }

    public IDrawable getBackground() {
        if (this.bg == null) {
            this.bg = JEICompat.GUI.createBlankDrawable(this.getWidth(), this.getHeight());
        }
        return this.bg;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public abstract IDrawable createIcon(IGuiHelper var1, List<T> var2);

    public Component getTitle() {
        return JEIREI.makeTitle(this.recipeType.getUid());
    }

    public int getWidth() {
        return 119;
    }

    public int getHeight() {
        return 59;
    }

    public abstract void setRecipe(IRecipeLayoutBuilder var1, T var2, IFocusGroup var3);

    public void actionGroup(IRecipeLayoutBuilder builder, T recipe, int x, int y) {
        BaseJEICategory.slotGroup(builder, x, y, 10000, ILycheeRecipe.filterHidden(recipe.getAllActions()).toList(), BaseJEICategory::actionSlot);
    }

    public void ingredientGroup(IRecipeLayoutBuilder builder, T recipe, int x, int y) {
        List<IngredientInfo> ingredients = JEIREI.generateShapelessInputs(recipe);
        BaseJEICategory.slotGroup(builder, x + 1, y + 1, 0, ingredients, (layout0, ingredient, i, x0, y0) -> {
            ItemStack[] items = ingredient.ingredient.m_43908_();
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, x0, y0);
            slot.addItemStacks(Stream.of(items).map($ -> ingredient.count == 1 ? $ : $.m_41777_()).peek($ -> $.m_41764_(ingredient.count)).toList());
            slot.setBackground(JEICompat.slot(ingredient.isCatalyst ? JEICompat.SlotType.CATALYST : JEICompat.SlotType.NORMAL), -1, -1);
            if (!ingredient.tooltips.isEmpty()) {
                slot.addTooltipCallback((stack, tooltip) -> tooltip.addAll(ingredient.tooltips));
            }
        });
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        this.drawInfoBadge(recipe, matrixStack, mouseX, mouseY);
    }

    public void drawInfoBadge(T recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        BaseJEICategory.drawInfoBadge(recipe, matrixStack, mouseX, mouseY, this.infoRect);
    }

    public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        return BaseJEICategory.getTooltipStrings(recipe, mouseX, mouseY, this.infoRect);
    }

    public boolean handleInput(T recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE && BaseJEICategory.hasInfoBadge(recipe) && this.infoRect.m_110087_((int)mouseX, (int)mouseY)) {
            return ClientProxy.postInfoBadgeClickEvent(recipe, input.m_84873_());
        }
        return false;
    }

    public boolean clickBlock(BlockState state, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE) {
            if (state.m_60713_(Blocks.f_50323_) || state.m_60713_(Blocks.f_50324_)) {
                state = Blocks.f_50322_.m_49966_();
            }
            IRecipesGui gui = JEICompat.RUNTIME.getRecipesGui();
            IFocusFactory factory = JEICompat.HELPERS.getFocusFactory();
            RecipeIngredientRole role = input.m_84873_() == 1 ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT;
            ItemStack stack = state.m_60734_().m_5456_().m_7968_();
            if (!stack.m_41619_()) {
                gui.show(factory.createFocus(role, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack));
                return true;
            }
            if (state.m_60734_() instanceof LiquidBlock) {
                IPlatformFluidHelper fluidHelper = JEICompat.HELPERS.getPlatformFluidHelper();
                Fluid fluid = state.m_60819_().m_76152_();
                gui.show(factory.createFocus(role, (IIngredientType)fluidHelper.getFluidIngredientType(), fluidHelper.create(fluid, fluidHelper.bucketVolume())));
                return true;
            }
        }
        return false;
    }

    @FunctionalInterface
    public static interface SlotLayoutFunction<T> {
        public void apply(IRecipeLayoutBuilder var1, T var2, int var3, int var4, int var5);
    }
}

