/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.jei.category;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import snownee.lychee.block_crushing.BlockCrushingContext;
import snownee.lychee.block_crushing.BlockCrushingRecipe;
import snownee.lychee.client.gui.AllGuiTextures;
import snownee.lychee.client.gui.GuiGameElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.compat.JEIREI;
import snownee.lychee.compat.jei.category.BaseJEICategory;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.util.CommonProxy;

public class BlockCrushingRecipeCategory
extends BaseJEICategory<BlockCrushingContext, BlockCrushingRecipe> {
    public static final Rect2i fallingBlockRect = new Rect2i(0, -35, 20, 35);
    public static final Rect2i landingBlockRect = new Rect2i(0, 0, 20, 20);

    public BlockCrushingRecipeCategory(LycheeRecipeType<BlockCrushingContext, BlockCrushingRecipe> recipeType) {
        super(recipeType);
    }

    @Override
    public int getWidth() {
        return 169;
    }

    @Override
    public IDrawable createIcon(IGuiHelper guiHelper, List<BlockCrushingRecipe> recipes) {
        return guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)Items.f_42146_.m_7968_());
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, BlockCrushingRecipe recipe, IFocusGroup focuses) {
        int xCenter = this.getWidth() / 2;
        int y = recipe.m_7527_().size() > 9 || recipe.showingActionsCount() > 9 ? 26 : 28;
        this.ingredientGroup(builder, recipe, xCenter - 45, y);
        this.actionGroup(builder, recipe, xCenter + 50, y);
        BlockCrushingRecipeCategory.addBlockIngredients(builder, recipe);
    }

    @Override
    public void draw(BlockCrushingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        this.drawInfoBadge(recipe, matrixStack, mouseX, mouseY);
        BlockState fallingBlock = CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(recipe.getBlock()), Blocks.f_50322_.m_49966_(), 2000);
        BlockState landingBlock = CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(recipe.getLandingBlock()), Blocks.f_50016_.m_49966_(), 2000);
        int x = recipe.m_7527_().isEmpty() ? 41 : 77;
        boolean anyLandingBlock = recipe.getLandingBlock() == BlockPredicate.f_17902_;
        int y = anyLandingBlock ? 45 : 36;
        float ticks = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
        ticks = Math.min(1.0f, ticks);
        ticks = ticks * ticks * ticks * ticks;
        if (landingBlock.m_60791_() < 5) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)x + 10.5, (double)(y + (anyLandingBlock ? 1 : 16)), 0.0);
            float shadow = 0.6f;
            if (anyLandingBlock) {
                shadow = 0.2f + ticks * 0.2f;
            }
            matrixStack.m_85841_(shadow, shadow, shadow);
            matrixStack.m_85837_(-26.0, -5.5, 0.0);
            AllGuiTextures.JEI_SHADOW.render(matrixStack, 0, 0);
            matrixStack.m_85849_();
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)(y - 13), 0.0);
        ((RenderElement)GuiGameElement.of(fallingBlock).scale(15.0).atLocal(0.0, (double)ticks * 1.3 - 1.3, 0.0).rotateBlock(20.0, 225.0, 0.0).lighting(JEIREI.BLOCK_LIGHTING).at(0.0f, 0.0f, 300.0f)).render(matrixStack);
        if (!landingBlock.m_60795_()) {
            GuiGameElement.of(landingBlock).scale(15.0).atLocal(0.0, 1.0, 0.0).rotateBlock(20.0, 225.0, 0.0).lighting(JEIREI.BLOCK_LIGHTING).render(matrixStack);
        }
        matrixStack.m_85849_();
    }

    @Override
    public List<Component> getTooltipStrings(BlockCrushingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int x = recipe.m_7527_().isEmpty() ? 41 : 77;
        int y = recipe.getLandingBlock() == BlockPredicate.f_17902_ ? 45 : 36;
        if (fallingBlockRect.m_110087_(x = (int)mouseX - x, y = (int)mouseY - y)) {
            BlockState fallingBlock = CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(recipe.getBlock()), Blocks.f_50322_.m_49966_(), 2000);
            return BlockPredicateHelper.getTooltips(fallingBlock, recipe.getBlock());
        }
        if (recipe.getLandingBlock() != BlockPredicate.f_17902_ && landingBlockRect.m_110087_(x, y)) {
            BlockState landingBlock = CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(recipe.getLandingBlock()), Blocks.f_50016_.m_49966_(), 2000);
            return BlockPredicateHelper.getTooltips(landingBlock, recipe.getLandingBlock());
        }
        return super.getTooltipStrings(recipe, recipeSlotsView, mouseX, mouseY);
    }

    @Override
    public boolean handleInput(BlockCrushingRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE) {
            int x = recipe.m_7527_().isEmpty() ? 41 : 77;
            int y = recipe.getLandingBlock() == BlockPredicate.f_17902_ ? 45 : 36;
            if (fallingBlockRect.m_110087_(x = (int)mouseX - x, y = (int)mouseY - y)) {
                BlockState fallingBlock = CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(recipe.getBlock()), Blocks.f_50322_.m_49966_(), 2000);
                return this.clickBlock(fallingBlock, input);
            }
            if (recipe.getLandingBlock() != BlockPredicate.f_17902_ && landingBlockRect.m_110087_(x, y)) {
                BlockState landingBlock = CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(recipe.getLandingBlock()), Blocks.f_50016_.m_49966_(), 2000);
                return this.clickBlock(landingBlock, input);
            }
        }
        return super.handleInput(recipe, mouseX, mouseY, input);
    }
}

