/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.rei.category;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.RecipeTypes;
import snownee.lychee.client.gui.AllGuiTextures;
import snownee.lychee.client.gui.GuiGameElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.client.gui.ScreenElement;
import snownee.lychee.compat.JEIREI;
import snownee.lychee.compat.rei.REICompat;
import snownee.lychee.compat.rei.ReactiveWidget;
import snownee.lychee.compat.rei.SideBlockIcon;
import snownee.lychee.compat.rei.category.BaseREICategory;
import snownee.lychee.compat.rei.display.BaseREIDisplay;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.ItemShapelessRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.interaction.BlockInteractingRecipe;
import snownee.lychee.util.CommonProxy;

public abstract class ItemAndBlockBaseCategory<C extends LycheeContext, T extends LycheeRecipe<C>, D extends BaseREIDisplay<T>>
extends BaseREICategory<C, T, D> {
    public Rect2i inputBlockRect = new Rect2i(30, 35, 20, 20);
    public Rect2i methodRect = new Rect2i(30, 12, 20, 20);
    private final ScreenElement mainIcon;

    public ItemAndBlockBaseCategory(List<LycheeRecipeType<C, T>> recipeTypes, ScreenElement mainIcon) {
        super(recipeTypes);
        this.mainIcon = mainIcon;
        this.infoRect.m_173049_(8, 32);
    }

    public BlockState getIconBlock(List<T> recipes) {
        ClientPacketListener con = Minecraft.m_91087_().m_91403_();
        if (con == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return JEIREI.getMostUsedBlock(recipes).getFirst();
    }

    @Nullable
    public BlockPredicate getInputBlock(T recipe) {
        return ((BlockKeyRecipe)recipe).getBlock();
    }

    public BlockState getRenderingBlock(T recipe) {
        return CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(this.getInputBlock(recipe)), Blocks.f_50016_.m_49966_(), 1000);
    }

    public void drawExtra(T recipe, PoseStack matrixStack, double mouseX, double mouseY, int centerX) {
        AllGuiTextures.JEI_DOWN_ARROW.render(matrixStack, this.methodRect.m_110085_(), this.methodRect.m_110086_());
    }

    @Nullable
    public Component getMethodDescription(T recipe) {
        return null;
    }

    @Override
    public List<Widget> setupDisplay(D display, Rectangle bounds) {
        ReactiveWidget reactive;
        int y;
        Point startPoint = new Point(bounds.getCenterX() - this.getRealWidth() / 2, bounds.getY() + 4);
        Object recipe = ((BaseREIDisplay)display).recipe;
        List<Widget> widgets = super.setupDisplay(display, bounds);
        this.drawInfoBadge(widgets, display, startPoint);
        widgets.add(Widgets.createDrawableWidget((helper, matrixStack, mouseX, mouseY, delta) -> {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)startPoint.x, (double)startPoint.y, 0.0);
            this.drawExtra(recipe, matrixStack, mouseX, mouseY, bounds.getCenterX());
            BlockState state = this.getRenderingBlock(recipe);
            if (state.m_60795_()) {
                AllGuiTextures.JEI_QUESTION_MARK.render(matrixStack, this.inputBlockRect.m_110085_() + 4, this.inputBlockRect.m_110086_() + 2);
                matrixStack.m_85849_();
                return;
            }
            if (state.m_60791_() < 5) {
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)(this.inputBlockRect.m_110085_() + 11), (double)(this.inputBlockRect.m_110086_() + 16), 0.0);
                matrixStack.m_85841_(0.7f, 0.7f, 0.7f);
                AllGuiTextures.JEI_SHADOW.render(matrixStack, -26, -5);
                matrixStack.m_85849_();
            }
            ((RenderElement)GuiGameElement.of(state).rotateBlock(12.5, -22.5, 0.0).scale(15.0).lighting(JEIREI.BLOCK_LIGHTING).atLocal(0.0, 0.2, 0.0).at(this.inputBlockRect.m_110085_(), this.inputBlockRect.m_110086_())).render(matrixStack);
            matrixStack.m_85849_();
        }));
        int n = y = recipe.m_7527_().size() > 9 || recipe.showingActionsCount() > 9 ? 26 : 28;
        if (recipe instanceof ItemShapelessRecipe) {
            this.ingredientGroup(widgets, startPoint, recipe, 40, y);
        } else if (recipe instanceof BlockInteractingRecipe) {
            this.ingredientGroup(widgets, startPoint, recipe, 22, 21);
        } else {
            this.ingredientGroup(widgets, startPoint, recipe, 12, 21);
        }
        this.actionGroup(widgets, startPoint, recipe, this.getRealWidth() - 34, y);
        Component description = this.getMethodDescription(recipe);
        if (description != null) {
            reactive = new ReactiveWidget(REICompat.offsetRect(startPoint, this.methodRect));
            reactive.setTooltipFunction($ -> new Component[]{description});
            widgets.add((Widget)reactive);
        }
        if (this.recipeTypes.get(0) != RecipeTypes.ITEM_BURNING) {
            reactive = new ReactiveWidget(REICompat.offsetRect(startPoint, this.inputBlockRect));
            reactive.setTooltipFunction($ -> {
                List<Component> list = BlockPredicateHelper.getTooltips(this.getRenderingBlock(recipe), this.getInputBlock(recipe));
                return list.toArray(new Component[0]);
            });
            reactive.setOnClick(($, button) -> this.clickBlock(this.getRenderingBlock(recipe), (int)button));
            widgets.add((Widget)reactive);
        }
        return widgets;
    }

    @Override
    public Renderer createIcon(List<T> recipes) {
        return new REICompat.ScreenElementWrapper(new SideBlockIcon(this.mainIcon, (Supplier<BlockState>)Suppliers.memoize(() -> this.getIconBlock(recipes))));
    }
}

