/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.contextual;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import snownee.lychee.ContextualConditionTypes;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualCondition;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.recipe.ILycheeRecipe;

public class DirectionCheck
implements ContextualCondition {
    public static final Map<String, DirectionCheck> LOOKUP = Maps.newHashMap();
    private final String name;
    private final Predicate<LycheeContext> predicate;

    public static void create(String name, Predicate<LycheeContext> predicate) {
        LOOKUP.put(name, new DirectionCheck(name, predicate));
    }

    private DirectionCheck(String name, Predicate<LycheeContext> predicate) {
        this.name = name;
        this.predicate = predicate;
    }

    @Override
    public ContextualConditionType<? extends ContextualCondition> getType() {
        return ContextualConditionTypes.DIRECTION;
    }

    @Override
    public int test(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        return this.predicate.test(ctx) ? times : 0;
    }

    @Override
    public MutableComponent getDescription(boolean inverted) {
        MutableComponent value = Component.m_237115_((String)("direction.lychee." + this.name)).m_130940_(ChatFormatting.WHITE);
        return Component.m_237110_((String)this.makeDescriptionId(inverted), (Object[])new Object[]{value});
    }

    static {
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n; ++i) {
            Direction direction;
            Direction direction2 = direction = directionArray[i];
            DirectionCheck.create(direction2.m_122433_().toLowerCase(Locale.ENGLISH), ctx -> ctx.getParam(LycheeLootContextParams.DIRECTION) == direction2);
        }
        DirectionCheck.create("sides", ctx -> ctx.getParam(LycheeLootContextParams.DIRECTION).m_122430_() == 0);
        DirectionCheck.create("forward", ctx -> {
            BlockState state;
            Direction facing;
            Direction direction = ctx.getParam(LycheeLootContextParams.DIRECTION);
            return direction == (facing = (Direction)(state = (BlockState)ctx.getParam(LootContextParams.f_81461_)).m_61145_((Property)BlockStateProperties.f_61372_).or(() -> state.m_61145_((Property)BlockStateProperties.f_61374_)).or(() -> state.m_61145_((Property)BlockStateProperties.f_155997_)).orElseThrow());
        });
        DirectionCheck.create("axis", ctx -> {
            Direction direction = ctx.getParam(LycheeLootContextParams.DIRECTION);
            BlockState state = (BlockState)ctx.getParam(LootContextParams.f_81461_);
            Direction.Axis axis = (Direction.Axis)state.m_61145_((Property)BlockStateProperties.f_61365_).or(() -> state.m_61145_((Property)BlockStateProperties.f_61364_)).orElseThrow();
            return axis.test(direction);
        });
    }

    public static class Type
    extends ContextualConditionType<DirectionCheck> {
        @Override
        public DirectionCheck fromJson(JsonObject o) {
            return LOOKUP.get(o.get("direction").getAsString());
        }

        @Override
        public void toJson(DirectionCheck condition, JsonObject o) {
            o.addProperty("direction", condition.name);
        }

        @Override
        public DirectionCheck fromNetwork(FriendlyByteBuf buf) {
            return LOOKUP.get(buf.m_130277_());
        }

        @Override
        public void toNetwork(DirectionCheck condition, FriendlyByteBuf buf) {
            buf.m_130070_(condition.name);
        }
    }
}

