/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.contextual;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.ContextualConditionTypes;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualCondition;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.def.BoundsHelper;
import snownee.lychee.core.def.LocationPredicateHelper;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.mixin.BlockPredicateAccess;
import snownee.lychee.mixin.LightPredicateAccess;
import snownee.lychee.mixin.LocationCheckAccess;
import snownee.lychee.mixin.LocationPredicateAccess;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.CommonProxy;

public record Location(LocationCheck check) implements ContextualCondition
{
    private static final Rule X = new PosRule("x", LocationPredicateAccess::getX, Vec3::m_7096_);
    private static final Rule Y = new PosRule("y", LocationPredicateAccess::getY, Vec3::m_7098_);
    private static final Rule Z = new PosRule("z", LocationPredicateAccess::getZ, Vec3::m_7094_);
    private static final Rule DIMENSION = new DimensionRule();
    private static final Rule FEATURE = new FeatureRule();
    private static final Rule BIOME = new BiomeRule();
    private static final Rule BLOCK = new BlockRule();
    private static final Rule FLUID = new FluidRule();
    private static final Rule LIGHT = new LightRule();
    private static final Rule SMOKEY = new SmokeyRule();
    public static final Rule[] RULES = new Rule[]{X, Y, Z, DIMENSION, FEATURE, BIOME, BLOCK, FLUID, LIGHT, SMOKEY};

    @Override
    public ContextualConditionType<? extends ContextualCondition> getType() {
        return ContextualConditionTypes.LOCATION;
    }

    @Override
    public int test(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        if (ctx.getLevel().f_46443_) {
            return this.testClient(ctx.getLevel(), ctx.getParamOrNull(LycheeLootContextParams.BLOCK_POS), (Vec3)ctx.getParamOrNull(LootContextParams.f_81460_)) == InteractionResult.SUCCESS ? times : 0;
        }
        return this.check.test(ctx.toLootContext()) ? times : 0;
    }

    @Override
    public InteractionResult testInTooltips(Level level, @Nullable Player player) {
        if (player == null) {
            return InteractionResult.PASS;
        }
        LocationCheckAccess checkAccess = (LocationCheckAccess)this.check;
        if (!BlockPos.f_121853_.equals((Object)checkAccess.getOffset())) {
            return InteractionResult.PASS;
        }
        Vec3 vec = player.m_20182_();
        BlockPos pos = player.m_20183_();
        return this.testClient(level, pos, vec);
    }

    public InteractionResult testClient(Level level, BlockPos pos, Vec3 vec) {
        LocationCheckAccess checkAccess = (LocationCheckAccess)this.check;
        BlockPos offset = checkAccess.getOffset();
        if (!BlockPos.f_121853_.equals((Object)offset)) {
            pos = pos.m_7918_(offset.m_123341_(), offset.m_123342_(), offset.m_123343_());
        }
        LocationPredicateAccess access = (LocationPredicateAccess)checkAccess.getPredicate();
        boolean hasPass = false;
        for (Rule rule : RULES) {
            if (rule.isAny(access)) continue;
            InteractionResult result = rule.testClient(access, level, pos, vec);
            if (result == InteractionResult.FAIL) {
                return result;
            }
            if (result != InteractionResult.PASS) continue;
            hasPass = true;
        }
        return hasPass ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    @Override
    public void appendTooltips(List<Component> tooltips, Level level, @Nullable Player player, int indent, boolean inverted) {
        LocationCheckAccess checkAccess = (LocationCheckAccess)this.check;
        LocationPredicateAccess access = (LocationPredicateAccess)checkAccess.getPredicate();
        boolean test = false;
        Vec3 vec = null;
        BlockPos pos = null;
        String key = this.makeDescriptionId(inverted);
        boolean noOffset = BlockPos.f_121853_.equals((Object)checkAccess.getOffset());
        if (!noOffset) {
            BlockPos offset = checkAccess.getOffset();
            MutableComponent content = Component.m_237110_((String)key, (Object[])new Object[]{offset.m_123341_(), offset.m_123342_(), offset.m_123343_()}).m_130940_(ChatFormatting.GRAY);
            InteractionResult result = this.testInTooltips(level, player);
            ContextualCondition.desc(tooltips, result, indent, content);
            ++indent;
        }
        if (noOffset && player != null) {
            test = true;
            vec = player.m_20182_();
            pos = player.m_20183_();
        }
        for (Rule rule : RULES) {
            if (rule.isAny(access)) continue;
            InteractionResult result = InteractionResult.PASS;
            if (test) {
                result = rule.testClient(access, level, pos, vec);
            }
            rule.appendTooltips(tooltips, indent, key, access, result);
        }
    }

    @Override
    public MutableComponent getDescription(boolean inverted) {
        return Component.m_237115_((String)this.makeDescriptionId(inverted));
    }

    @Override
    public int showingCount() {
        int c = 0;
        LocationCheckAccess checkAccess = (LocationCheckAccess)this.check;
        LocationPredicateAccess access = (LocationPredicateAccess)checkAccess.getPredicate();
        for (Rule rule : RULES) {
            if (rule.isAny(access)) continue;
            ++c;
        }
        return c;
    }

    public static interface Rule {
        public String getName();

        public boolean isAny(LocationPredicateAccess var1);

        default public InteractionResult testClient(LocationPredicateAccess access, Level level, BlockPos pos, Vec3 vec) {
            return InteractionResult.PASS;
        }

        public void appendTooltips(List<Component> var1, int var2, String var3, LocationPredicateAccess var4, InteractionResult var5);
    }

    private record PosRule(String name, Function<LocationPredicateAccess, MinMaxBounds.Doubles> boundsGetter, Function<Vec3, Double> valueGetter) implements Rule
    {
        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return this.boundsGetter.apply(access).m_55327_();
        }

        @Override
        public InteractionResult testClient(LocationPredicateAccess access, Level level, BlockPos pos, Vec3 vec) {
            return CommonProxy.interactionResult(this.boundsGetter.apply(access).m_154810_(this.valueGetter.apply(vec).doubleValue()));
        }

        @Override
        public void appendTooltips(List<Component> tooltips, int indent, String key, LocationPredicateAccess access, InteractionResult result) {
            ContextualCondition.desc(tooltips, result, indent, Component.m_237110_((String)(key + "." + this.getName()), (Object[])new Object[]{BoundsHelper.getDescription((MinMaxBounds)this.boundsGetter.apply(access)).m_130940_(ChatFormatting.WHITE)}));
        }
    }

    private static class DimensionRule
    implements Rule {
        private DimensionRule() {
        }

        @Override
        public String getName() {
            return "dimension";
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return access.getDimension() == null;
        }

        @Override
        public InteractionResult testClient(LocationPredicateAccess access, Level level, BlockPos pos, Vec3 vec) {
            return CommonProxy.interactionResult(level.m_46472_() == access.getDimension());
        }

        @Override
        public void appendTooltips(List<Component> tooltips, int indent, String key, LocationPredicateAccess access, InteractionResult result) {
            MutableComponent name = ClientProxy.getDimensionDisplayName(access.getDimension()).m_130940_(ChatFormatting.WHITE);
            ContextualCondition.desc(tooltips, result, indent, Component.m_237110_((String)(key + "." + this.getName()), (Object[])new Object[]{name}));
        }
    }

    private static class FeatureRule
    implements Rule {
        private FeatureRule() {
        }

        @Override
        public String getName() {
            return "feature";
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return access.getStructure() == null;
        }

        @Override
        public void appendTooltips(List<Component> tooltips, int indent, String key, LocationPredicateAccess access, InteractionResult result) {
            MutableComponent name = ClientProxy.getStructureDisplayName(access.getStructure().m_135782_()).m_130940_(ChatFormatting.WHITE);
            ContextualCondition.desc(tooltips, result, indent, Component.m_237110_((String)(key + "." + this.getName()), (Object[])new Object[]{name}));
        }
    }

    private static class BiomeRule
    implements Rule {
        private BiomeRule() {
        }

        @Override
        public String getName() {
            return "biome";
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return access.getBiome() == null && ((LocationPredicateHelper)((Object)access)).lychee$getBiomeTag() == null;
        }

        @Override
        public InteractionResult testClient(LocationPredicateAccess access, Level level, BlockPos pos, Vec3 vec) {
            Holder biome = level.m_204166_(pos);
            if (access.getBiome() != null && biome.m_203373_(access.getBiome().m_135782_())) {
                return InteractionResult.SUCCESS;
            }
            TagKey<Biome> tag = ((LocationPredicateHelper)((Object)access)).lychee$getBiomeTag();
            if (tag != null && biome.m_203656_(tag)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }

        @Override
        public void appendTooltips(List<Component> tooltips, int indent, String key, LocationPredicateAccess access, InteractionResult result) {
            String valueKey = access.getBiome() != null ? Util.m_137492_((String)"biome", (ResourceLocation)access.getBiome().m_135782_()) : Util.m_137492_((String)"biomeTag", (ResourceLocation)((LocationPredicateHelper)((Object)access)).lychee$getBiomeTag().f_203868_());
            MutableComponent name = Component.m_237115_((String)valueKey).m_130940_(ChatFormatting.WHITE);
            ContextualCondition.desc(tooltips, result, indent, Component.m_237110_((String)(key + "." + this.getName()), (Object[])new Object[]{name}));
        }
    }

    private static class BlockRule
    implements Rule {
        private BlockRule() {
        }

        @Override
        public String getName() {
            return "block";
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return access.getBlock() == BlockPredicate.f_17902_;
        }

        @Override
        public void appendTooltips(List<Component> tooltips, int indent, String key, LocationPredicateAccess access, InteractionResult result) {
            Block block = CommonProxy.getCycledItem(List.copyOf(BlockPredicateHelper.getMatchedBlocks(access.getBlock())), Blocks.f_50016_, 1000);
            MutableComponent name = block.m_49954_().m_130940_(ChatFormatting.WHITE);
            BlockPredicateAccess blockAccess = (BlockPredicateAccess)access.getBlock();
            if (blockAccess.getProperties() != StatePropertiesPredicate.f_67658_ || blockAccess.getNbt() != NbtPredicate.f_57471_) {
                name.m_130946_("*");
            }
            ContextualCondition.desc(tooltips, result, indent, Component.m_237110_((String)(key + "." + this.getName()), (Object[])new Object[]{name}));
        }

        @Override
        public InteractionResult testClient(LocationPredicateAccess access, Level level, BlockPos pos, Vec3 vec) {
            return BlockPredicateHelper.fastMatch(access.getBlock(), level.m_8055_(pos), () -> level.m_7702_(pos)) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
    }

    private static class FluidRule
    implements Rule {
        private FluidRule() {
        }

        @Override
        public String getName() {
            return "fluid";
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return access.getFluid() == FluidPredicate.f_41094_;
        }

        @Override
        public void appendTooltips(List<Component> tooltips, int indent, String key, LocationPredicateAccess access, InteractionResult result) {
        }
    }

    private static class LightRule
    implements Rule {
        private LightRule() {
        }

        @Override
        public String getName() {
            return "light";
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return access.getLight() == LightPredicate.f_51335_;
        }

        @Override
        public InteractionResult testClient(LocationPredicateAccess access, Level level, BlockPos pos, Vec3 vec) {
            int light = level.m_46803_(pos);
            return CommonProxy.interactionResult(((LightPredicateAccess)access.getLight()).getComposite().m_55390_(light));
        }

        @Override
        public void appendTooltips(List<Component> tooltips, int indent, String key, LocationPredicateAccess access, InteractionResult result) {
            MutableComponent bounds = BoundsHelper.getDescription(((LightPredicateAccess)access.getLight()).getComposite()).m_130940_(ChatFormatting.WHITE);
            ContextualCondition.desc(tooltips, result, indent, Component.m_237110_((String)(key + "." + this.getName()), (Object[])new Object[]{bounds}));
        }
    }

    private static class SmokeyRule
    implements Rule {
        private SmokeyRule() {
        }

        @Override
        public String getName() {
            return "smokey";
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return access.getSmokey() == null;
        }

        @Override
        public void appendTooltips(List<Component> tooltips, int indent, String key, LocationPredicateAccess access, InteractionResult result) {
            key = (String)key + "." + this.getName();
            if (access.getSmokey() == Boolean.FALSE) {
                key = (String)key + ".not";
            }
            ContextualCondition.desc(tooltips, result, indent, Component.m_237115_((String)key));
        }
    }

    public static class Type
    extends ContextualConditionType<Location> {
        @Override
        public Location fromJson(JsonObject o) {
            LocationCheck check = (LocationCheck)LootItemConditions.f_81823_.m_79331_().m_7561_(o, (JsonDeserializationContext)ContextualCondition.gsonContext);
            return new Location(check);
        }

        @Override
        public void toJson(Location condition, JsonObject o) {
            new LocationCheck.Serializer().m_6170_(o, condition.check(), (JsonSerializationContext)ContextualCondition.gsonContext);
        }

        @Override
        public Location fromNetwork(FriendlyByteBuf buf) {
            LocationPredicate.Builder builder = LocationPredicateHelper.fromNetwork(buf);
            LocationCheck check = (LocationCheck)LocationCheck.m_81727_((LocationPredicate.Builder)builder, (BlockPos)buf.m_130135_()).m_6409_();
            ResourceLocation biomeTag = CommonProxy.readNullableRL(buf);
            if (biomeTag != null) {
                LocationPredicateHelper access = (LocationPredicateHelper)((LocationCheckAccess)check).getPredicate();
                access.lychee$setBiomeTag((TagKey<Biome>)TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)biomeTag));
            }
            return new Location(check);
        }

        @Override
        public void toNetwork(Location condition, FriendlyByteBuf buf) {
            LocationCheckAccess access = (LocationCheckAccess)condition.check();
            LocationPredicateHelper.toNetwork(access.getPredicate(), buf);
            buf.m_130064_(access.getOffset());
            ResourceLocation biomeTag = Optional.ofNullable(((LocationPredicateHelper)access.getPredicate()).lychee$getBiomeTag()).map(TagKey::f_203868_).orElse(null);
            CommonProxy.writeNullableRL(biomeTag, buf);
        }
    }
}

