/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.def;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.def.PropertiesPredicateHelper;
import snownee.lychee.mixin.BlockPredicateAccess;
import snownee.lychee.mixin.StatePropertiesPredicateAccess;
import snownee.lychee.util.CommonProxy;

public class BlockPredicateHelper {
    public static final NbtPredicate NBT_PREDICATE_DUMMY = new NbtPredicate(new CompoundTag());
    private static final Cache<BlockPredicate, List<BlockState>> CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    public static Set<Property<?>> ITERABLE_PROPERTIES = Sets.newConcurrentHashSet();

    public static Set<Block> getMatchedBlocks(BlockPredicate predicate) {
        BlockPredicateAccess access = (BlockPredicateAccess)predicate;
        LinkedHashSet blocks = Sets.newLinkedHashSet();
        if (access.getBlocks() != null) {
            blocks.addAll(access.getBlocks());
        }
        if (access.getTag() != null) {
            blocks.addAll(CommonProxy.tagElements(Registry.f_122824_, access.getTag()));
        }
        return blocks;
    }

    public static Set<Fluid> getMatchedFluids(BlockPredicate predicate) {
        return BlockPredicateHelper.getMatchedBlocks(predicate).stream().filter(LiquidBlock.class::isInstance).map(Block::m_49966_).map(BlockBehaviour.BlockStateBase::m_60819_).filter(Predicate.not(FluidState::m_76178_)).map(FluidState::m_76152_).collect(Collectors.toSet());
    }

    public static List<ItemStack> getMatchedItemStacks(BlockPredicate predicate) {
        return BlockPredicateHelper.getMatchedBlocks(predicate).stream().map(Block::m_5456_).filter(Predicate.not(Items.f_41852_::equals)).distinct().map(Item::m_7968_).toList();
    }

    public static boolean fastMatch(BlockPredicate predicate, LycheeContext context) {
        return BlockPredicateHelper.fastMatch(predicate, (BlockState)context.getParam(LootContextParams.f_81461_), () -> (BlockEntity)context.getParamOrNull(LootContextParams.f_81462_));
    }

    public static boolean fastMatch(BlockPredicate predicate, BlockState blockstate, Supplier<BlockEntity> beGetter) {
        BlockEntity blockentity;
        if (predicate == BlockPredicate.f_17902_) {
            return true;
        }
        BlockPredicateAccess access = (BlockPredicateAccess)predicate;
        if (access.getTag() != null && !blockstate.m_204336_(access.getTag())) {
            return false;
        }
        if (access.getBlocks() != null && !access.getBlocks().contains(blockstate.m_60734_())) {
            return false;
        }
        if (!access.getProperties().m_67667_(blockstate)) {
            return false;
        }
        return access.getNbt() == NbtPredicate.f_57471_ || (blockentity = beGetter.get()) != null && access.getNbt().m_57483_((Tag)blockentity.m_187480_());
    }

    public static BlockPredicate fromJson(JsonElement jsonElement) {
        if (jsonElement != null && jsonElement.isJsonPrimitive()) {
            String id = jsonElement.getAsString();
            if ("*".equals(id)) {
                return BlockPredicate.f_17902_;
            }
            if (id.startsWith("#")) {
                TagKey key = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(id.substring(1)));
                return new BlockPredicate(key, null, StatePropertiesPredicate.f_67658_, NbtPredicate.f_57471_);
            }
            Block block = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(id));
            return new BlockPredicate(null, Set.of(block), StatePropertiesPredicate.f_67658_, NbtPredicate.f_57471_);
        }
        return BlockPredicate.m_17917_((JsonElement)jsonElement);
    }

    public static JsonElement toJson(BlockPredicate predicate) {
        if (predicate == BlockPredicate.f_17902_) {
            return new JsonPrimitive("*");
        }
        return predicate.m_17913_();
    }

    public static BlockPredicate fromNetwork(FriendlyByteBuf pBuffer) {
        int blockCount = pBuffer.m_130242_();
        if (blockCount == -1) {
            return BlockPredicate.f_17902_;
        }
        HashSet blocks = null;
        if (blockCount > 0) {
            blocks = Sets.newHashSet();
            for (int i = 0; i < blockCount; ++i) {
                blocks.add((Block)CommonProxy.readRegistryId(Registry.f_122824_, pBuffer));
            }
        }
        TagKey tag = null;
        ResourceLocation tagId = CommonProxy.readNullableRL(pBuffer);
        if (tagId != null) {
            tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)tagId);
        }
        StatePropertiesPredicate propertiesPredicate = PropertiesPredicateHelper.fromNetwork(pBuffer);
        NbtPredicate nbtPredicate = pBuffer.readBoolean() ? NBT_PREDICATE_DUMMY : NbtPredicate.f_57471_;
        return new BlockPredicate(tag, (Set)blocks, propertiesPredicate, nbtPredicate);
    }

    public static void toNetwork(BlockPredicate predicate, FriendlyByteBuf pBuffer) {
        if (predicate == BlockPredicate.f_17902_) {
            pBuffer.m_130130_(-1);
            return;
        }
        BlockPredicateAccess access = (BlockPredicateAccess)predicate;
        Set<Block> blocks = access.getBlocks();
        if (blocks == null) {
            pBuffer.m_130130_(0);
        } else {
            pBuffer.m_130130_(blocks.size());
            for (Block block : blocks) {
                CommonProxy.writeRegistryId(Registry.f_122824_, block, pBuffer);
            }
        }
        ResourceLocation tagId = null;
        TagKey<Block> tag = access.getTag();
        if (tag != null) {
            tagId = tag.f_203868_();
        }
        CommonProxy.writeNullableRL(tagId, pBuffer);
        PropertiesPredicateHelper.toNetwork(access.getProperties(), pBuffer);
        NbtPredicate nbtPredicate = access.getNbt();
        pBuffer.writeBoolean(nbtPredicate != NbtPredicate.f_57471_);
    }

    public static BlockState anyBlockState(BlockPredicate predicate) {
        return BlockPredicateHelper.getShowcaseBlockStates(predicate).stream().findFirst().orElse(Blocks.f_50016_.m_49966_());
    }

    public static List<BlockState> getShowcaseBlockStates(BlockPredicate predicate) {
        try {
            return (List)CACHE.get((Object)predicate, () -> BlockPredicateHelper.getShowcaseBlockStates(predicate, ITERABLE_PROPERTIES));
        }
        catch (ExecutionException e) {
            return List.of();
        }
    }

    public static List<BlockState> getShowcaseBlockStates(BlockPredicate predicate, Collection<Property<?>> iterableProperties) {
        Set<Block> blocks = BlockPredicateHelper.getMatchedBlocks(predicate);
        if (blocks.isEmpty()) {
            return List.of();
        }
        ArrayList states = Lists.newArrayList();
        BlockPredicateAccess access = (BlockPredicateAccess)predicate;
        StatePropertiesPredicate propertiesPredicate = access.getProperties();
        for (Block block : blocks) {
            BlockState state = block.m_49966_();
            ArrayListMultimap propertyMap = ArrayListMultimap.create();
            for (Property property : block.m_49965_().m_61092_()) {
                String name = property.m_61708_();
                StatePropertiesPredicate.PropertyMatcher matcher = PropertiesPredicateHelper.findMatcher(propertiesPredicate, name);
                if (matcher != null) {
                    for (Comparable object : property.m_6908_()) {
                        if (!matcher.m_67718_(block.m_49965_(), (StateHolder)((BlockState)state.m_61124_(property, object)))) continue;
                        propertyMap.put((Object)property, (Object)object);
                    }
                    continue;
                }
                if (!iterableProperties.contains(property)) continue;
                propertyMap.putAll((Object)property, (Iterable)property.m_6908_());
            }
            Stream<Object> stream = Stream.of(state);
            for (Map.Entry e : propertyMap.asMap().entrySet()) {
                stream = stream.flatMap($ -> ((Collection)e.getValue()).stream().map(v -> (BlockState)$.m_61124_((Property)e.getKey(), v)));
            }
            states.addAll(stream.toList());
        }
        return states;
    }

    public static List<Component> getTooltips(BlockState state, BlockPredicate predicate) {
        if (predicate == BlockPredicate.f_17902_) {
            return List.of(Component.m_237115_((String)"tip.lychee.anyBlock"));
        }
        ArrayList list = Lists.newArrayList((Object[])new Component[]{state.m_60734_().m_49954_()});
        BlockPredicateAccess access = (BlockPredicateAccess)predicate;
        List<StatePropertiesPredicate.PropertyMatcher> matchers = ((StatePropertiesPredicateAccess)access.getProperties()).getProperties();
        for (StatePropertiesPredicate.PropertyMatcher matcher : matchers) {
            MutableComponent name = Component.m_237113_((String)(matcher.m_67726_() + "=")).m_130940_(ChatFormatting.GRAY);
            JsonElement json = matcher.m_7682_();
            if (json.isJsonPrimitive()) {
                name.m_7220_((Component)Component.m_237113_((String)json.getAsString()).m_130940_(ChatFormatting.WHITE));
            } else {
                JsonObject object = json.getAsJsonObject();
                StateDefinition definition = state.m_60734_().m_49965_();
                Property property = definition.m_61081_(matcher.m_67726_());
                List sorted = null;
                boolean hasMin = object.has("min");
                boolean hasMax = object.has("max");
                Preconditions.checkArgument((hasMin || hasMax ? 1 : 0) != 0);
                if (!hasMin || !hasMax) {
                    sorted = property.m_6908_().stream().sorted().toList();
                }
                String min = hasMin ? object.get("min").getAsString() : property.m_6940_((Comparable)sorted.get(0));
                String max = hasMax ? object.get("max").getAsString() : property.m_6940_((Comparable)sorted.get(sorted.size() - 1));
                name.m_7220_((Component)Component.m_237113_((String)min).m_130940_(ChatFormatting.WHITE));
                name.m_7220_((Component)Component.m_237113_((String)"~").m_130940_(ChatFormatting.GRAY));
                name.m_7220_((Component)Component.m_237113_((String)max).m_130940_(ChatFormatting.WHITE));
            }
            list.add(name);
        }
        if (access.getNbt() != NbtPredicate.f_57471_) {
            list.add(Component.m_237115_((String)"tip.lychee.nbtPredicate").m_130940_(ChatFormatting.GRAY));
        }
        return list;
    }

    static {
        ITERABLE_PROPERTIES.addAll(List.of(BlockStateProperties.f_61405_, BlockStateProperties.f_61406_, BlockStateProperties.f_61407_, BlockStateProperties.f_61408_, BlockStateProperties.f_61409_, BlockStateProperties.f_155994_, BlockStateProperties.f_61412_, BlockStateProperties.f_61426_, BlockStateProperties.f_61448_, BlockStateProperties.f_61443_, BlockStateProperties.f_155977_, BlockStateProperties.f_61446_, BlockStateProperties.f_61413_, BlockStateProperties.f_61414_, BlockStateProperties.f_61417_, BlockStateProperties.f_61425_, BlockStateProperties.f_61422_, BlockStateProperties.f_61421_, BlockStateProperties.f_61418_, BlockStateProperties.f_155998_));
    }
}

