/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import snownee.lychee.PostActionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.def.BoundsHelper;
import snownee.lychee.core.def.DoubleBoundsHelper;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.CommonProxy;

public class Hurt
extends PostAction {
    public final MinMaxBounds.Doubles damage;
    public final SourceType source;

    public Hurt(MinMaxBounds.Doubles damage, SourceType source) {
        this.damage = damage;
        this.source = source;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.HURT;
    }

    @Override
    public void doApply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        this.apply(recipe, ctx, times);
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        Entity entity = (Entity)ctx.getParam(LootContextParams.f_81455_);
        entity.f_19802_ = 0;
        entity.m_6469_(this.source.value, DoubleBoundsHelper.random(this.damage, ctx.getRandom()) * (float)times);
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237110_((String)CommonProxy.makeDescriptionId("postAction", this.getType().getRegistryName()), (Object[])new Object[]{BoundsHelper.getDescription(this.damage)});
    }

    public static enum SourceType {
        GENERIC(DamageSource.f_19318_),
        MAGIC(DamageSource.f_19319_),
        OUT_OF_WORLD(DamageSource.f_19317_),
        ANVIL(DamageSource.f_19321_),
        WITHER(DamageSource.f_19320_),
        FREEZE(DamageSource.f_146701_),
        DROWN(DamageSource.f_19312_),
        FALL(DamageSource.f_19315_),
        IN_FIRE(DamageSource.f_19305_),
        ON_FIRE(DamageSource.f_19307_),
        LAVA(DamageSource.f_19308_);

        public final DamageSource value;

        private SourceType(DamageSource value) {
            this.value = value;
        }

        public static SourceType parse(String s) {
            try {
                return SourceType.valueOf(s.toUpperCase(Locale.ENGLISH));
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static class Type
    extends PostActionType<Hurt> {
        @Override
        public Hurt fromJson(JsonObject o) {
            return new Hurt(MinMaxBounds.Doubles.m_154791_((JsonElement)o.get("damage")), SourceType.parse(GsonHelper.m_13851_((JsonObject)o, (String)"source", (String)SourceType.GENERIC.name())));
        }

        @Override
        public void toJson(Hurt action, JsonObject o) {
            o.add("damage", action.damage.m_55328_());
            if (action.source != SourceType.GENERIC) {
                o.addProperty("source", action.source.name().toLowerCase(Locale.ENGLISH));
            }
        }

        @Override
        public Hurt fromNetwork(FriendlyByteBuf buf) {
            return new Hurt(DoubleBoundsHelper.fromNetwork(buf), (SourceType)buf.m_130066_(SourceType.class));
        }

        @Override
        public void toNetwork(Hurt action, FriendlyByteBuf buf) {
            DoubleBoundsHelper.toNetwork(action.damage, buf);
            buf.m_130068_((Enum)action.source);
        }
    }
}

