/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.recipe;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.util.CommonProxy;

public abstract class ItemAndBlockRecipe<C extends LycheeContext>
extends LycheeRecipe<C>
implements BlockKeyRecipe<ItemAndBlockRecipe<C>> {
    protected Ingredient input;
    protected BlockPredicate block;

    public ItemAndBlockRecipe(ResourceLocation id) {
        super(id);
    }

    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public BlockPredicate getBlock() {
        return this.block;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input});
    }

    public boolean matches(LycheeContext ctx, Level pLevel) {
        Entity thisEntity = (Entity)ctx.getParam(LootContextParams.f_81455_);
        ItemStack stack = thisEntity instanceof ItemEntity ? ((ItemEntity)thisEntity).m_32055_() : ctx.m_8020_(0);
        return this.input.test(stack) && BlockPredicateHelper.fastMatch(this.block, ctx);
    }

    @Override
    public int compareTo(ItemAndBlockRecipe<C> that) {
        int i = Integer.compare(this.getMaxRepeats().m_55327_() ? 1 : 0, that.getMaxRepeats().m_55327_() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = Integer.compare(this.m_5598_() ? 1 : 0, that.m_5598_() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = Integer.compare(this.block == BlockPredicate.f_17902_ ? 1 : 0, that.block == BlockPredicate.f_17902_ ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = Integer.compare(CommonProxy.isSimpleIngredient(this.input) ? 1 : 0, CommonProxy.isSimpleIngredient(that.input) ? 1 : 0);
        if (i != 0) {
            return i;
        }
        return this.m_6423_().compareTo(that.m_6423_());
    }

    public static class Serializer<T extends ItemAndBlockRecipe<?>>
    extends LycheeRecipe.Serializer<T> {
        public Serializer(Function<ResourceLocation, T> factory) {
            super(factory);
        }

        @Override
        public void fromJson(T pRecipe, JsonObject pSerializedRecipe) {
            ((ItemAndBlockRecipe)pRecipe).input = Serializer.parseIngredientOrAir(pSerializedRecipe.get("item_in"));
            ((ItemAndBlockRecipe)pRecipe).block = BlockPredicateHelper.fromJson(pSerializedRecipe.get("block_in"));
        }

        @Override
        public void fromNetwork(T pRecipe, FriendlyByteBuf pBuffer) {
            ((ItemAndBlockRecipe)pRecipe).input = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ((ItemAndBlockRecipe)pRecipe).block = BlockPredicateHelper.fromNetwork(pBuffer);
        }

        @Override
        public void toNetwork0(FriendlyByteBuf pBuffer, T pRecipe) {
            ((ItemAndBlockRecipe)pRecipe).input.m_43923_(pBuffer);
            BlockPredicateHelper.toNetwork(((ItemAndBlockRecipe)pRecipe).block, pBuffer);
        }
    }
}

