/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.recipe.type;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.Chance;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.input.ItemHolderCollection;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.ChanceRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.Pair;

public class BlockKeyRecipeType<C extends LycheeContext, T extends LycheeRecipe<C>>
extends LycheeRecipeType<C, T> {
    protected final Map<Block, List<T>> recipesByBlock = Maps.newHashMap();
    protected final List<T> anyBlockRecipes = Lists.newLinkedList();
    public boolean extractChance;

    public BlockKeyRecipeType(String name, Class<T> clazz, @Nullable LootContextParamSet paramSet) {
        super(name, clazz, paramSet);
    }

    @Override
    public void buildCache() {
        this.recipesByBlock.clear();
        this.anyBlockRecipes.clear();
        super.buildCache();
        HashMultimap multimap = HashMultimap.create();
        for (LycheeRecipe lycheeRecipe : this.recipes) {
            Object condition;
            if (!lycheeRecipe.getConditions().isEmpty() && (condition = lycheeRecipe.getConditions().get(0)) instanceof Chance) {
                Chance chance = (Chance)condition;
                ((ChanceRecipe)((Object)lycheeRecipe)).setChance(chance.chance());
            }
            if (((BlockKeyRecipe)((Object)lycheeRecipe)).getBlock() == BlockPredicate.f_17902_) {
                this.anyBlockRecipes.add(lycheeRecipe);
                continue;
            }
            condition = BlockPredicateHelper.getMatchedBlocks(((BlockKeyRecipe)((Object)lycheeRecipe)).getBlock()).iterator();
            while (condition.hasNext()) {
                Block block = (Block)condition.next();
                multimap.put((Object)block, (Object)lycheeRecipe);
            }
        }
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            ArrayList list = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
            list.sort(null);
            this.recipesByBlock.put((Block)entry.getKey(), list);
        }
    }

    public List<ItemStack> blockKeysToItems() {
        return this.recipesByBlock.keySet().stream().map(Block::m_5456_).filter($ -> $ != Items.f_41852_).sorted((a, b) -> Integer.compare(Item.m_41393_((Item)a), Item.m_41393_((Item)b))).map(Item::m_7968_).toList();
    }

    public Optional<T> process(Player player, InteractionHand hand, BlockPos pos, Vec3 origin, LycheeContext.Builder<C> ctxBuilder) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        Level level = player.f_19853_;
        BlockState blockstate = level.m_8055_(pos);
        Collection recipes = this.recipesByBlock.getOrDefault(blockstate.m_60734_(), List.of());
        if (recipes.isEmpty() && this.anyBlockRecipes.isEmpty()) {
            return Optional.empty();
        }
        ctxBuilder.withParameter(LootContextParams.f_81460_, CommonProxy.clampPos(origin, pos));
        ctxBuilder.withParameter(LootContextParams.f_81455_, player);
        ctxBuilder.withParameter(LootContextParams.f_81461_, blockstate);
        ctxBuilder.withParameter(LycheeLootContextParams.BLOCK_POS, pos);
        C ctx = ctxBuilder.create(this.contextParamSet);
        ItemStack stack = player.m_21120_(hand);
        ItemStack otherStack = player.m_21120_(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        ((LycheeContext)ctx).itemHolders = ItemHolderCollection.Inventory.of(ctx, new ItemStack[]{stack, otherStack});
        Iterable iterable = Iterables.concat((Iterable)recipes, this.anyBlockRecipes);
        for (LycheeRecipe recipe : iterable) {
            if (!this.tryMatch(recipe, level, ctx).isPresent()) continue;
            if (!level.f_46443_ && recipe.tickOrApply(ctx)) {
                int times = Math.min(((LycheeContext)ctx).m_8020_(0).m_41613_(), ((LycheeContext)ctx).m_8020_(1).m_41613_());
                times = recipe.getRandomRepeats(Math.max(1, times), ctx);
                if (recipe.m_7527_().size() == 1) {
                    ((LycheeContext)ctx).itemHolders.ignoreConsumptionFlags.set(1);
                }
                recipe.applyPostActions((LycheeContext)ctx, times);
                ((LycheeContext)ctx).itemHolders.postApply(((LycheeContext)ctx).runtime.doDefault, times);
                player.m_21008_(hand, ((LycheeContext)ctx).m_8020_(0));
                player.m_21008_(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND, ((LycheeContext)ctx).m_8020_(1));
            }
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    public boolean has(Block block) {
        return !this.anyBlockRecipes.isEmpty() || this.recipesByBlock.containsKey(block);
    }

    public boolean has(BlockState state) {
        return this.has(state.m_60734_());
    }

    @Nullable
    public Pair<C, T> process(Level level, BlockState state, Supplier<C> ctxSupplier) {
        Collection recipes = this.recipesByBlock.getOrDefault(state.m_60734_(), List.of());
        Iterable iterable = Iterables.concat((Iterable)recipes, this.anyBlockRecipes);
        LycheeContext ctx = null;
        for (LycheeRecipe recipe : iterable) {
            ChanceRecipe $;
            if (this.extractChance && ($ = (ChanceRecipe)((Object)recipe)).getChance() != 1.0f && $.getChance() <= level.f_46441_.m_188501_()) continue;
            if (ctx == null) {
                ctx = (LycheeContext)ctxSupplier.get();
            }
            if (!this.tryMatch(recipe, level, ctx).isPresent()) continue;
            recipe.applyPostActions(ctx, 1);
            return Pair.of(ctx, recipe);
        }
        return null;
    }
}

