/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.dripstone_dripping;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParamSets;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.core.Job;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.Location;
import snownee.lychee.core.contextual.Not;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.post.Break;
import snownee.lychee.core.post.Delay;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.ChanceRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.dripstone_dripping.DripstoneContext;
import snownee.lychee.mixin.PointedDripstoneBlockAccess;
import snownee.lychee.util.Pair;

public class DripstoneRecipe
extends LycheeRecipe<DripstoneContext>
implements BlockKeyRecipe<DripstoneRecipe>,
ChanceRecipe {
    private float chance = 1.0f;
    protected BlockPredicate sourceBlock;
    protected BlockPredicate targetBlock;

    public DripstoneRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(DripstoneContext ctx, Level level) {
        if (!BlockPredicateHelper.fastMatch(this.targetBlock, ctx)) {
            return false;
        }
        return BlockPredicateHelper.fastMatch(this.sourceBlock, ctx.source, () -> level.m_7702_(ctx.getParam(LycheeLootContextParams.BLOCK_POS)));
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    public LycheeRecipe.Serializer<?> getSerializer() {
        return RecipeSerializers.DRIPSTONE_DRIPPING;
    }

    @Override
    public LycheeRecipeType<?, ?> getType() {
        return RecipeTypes.DRIPSTONE_DRIPPING;
    }

    @Override
    public int compareTo(DripstoneRecipe that) {
        int i = Integer.compare(this.m_5598_() ? 1 : 0, that.m_5598_() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = Integer.compare(this.targetBlock == BlockPredicate.f_17902_ ? 1 : 0, that.targetBlock == BlockPredicate.f_17902_ ? 1 : 0);
        if (i != 0) {
            return i;
        }
        return this.m_6423_().compareTo(that.m_6423_());
    }

    @Override
    public BlockPredicate getBlock() {
        return this.targetBlock;
    }

    public BlockPredicate getSourceBlock() {
        return this.sourceBlock;
    }

    @Override
    public List<BlockPredicate> getBlockInputs() {
        return List.of(this.sourceBlock, this.targetBlock);
    }

    @Override
    public void applyPostActions(LycheeContext ctx, int times) {
        if (!ctx.getLevel().f_46443_) {
            ctx.enqueueActions(this.getPostActions(), times, true);
        }
    }

    public static boolean safeTick(BlockState state, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!PointedDripstoneBlockAccess.callIsStalactiteStartPos(state, (LevelReader)serverLevel, blockPos)) {
            return false;
        }
        float f = randomSource.m_188501_();
        if (f > 0.17578125f && f > 0.05859375f) {
            return false;
        }
        return DripstoneRecipe.on(state, serverLevel, blockPos);
    }

    public static boolean on(BlockState blockState, ServerLevel level, BlockPos blockPos) {
        if (RecipeTypes.DRIPSTONE_DRIPPING.isEmpty()) {
            return false;
        }
        BlockPos tipPos = PointedDripstoneBlockAccess.callFindTip(blockState, (LevelAccessor)level, blockPos, 11, false);
        if (tipPos == null) {
            return false;
        }
        BlockPos targetPos = DripstoneRecipe.findTargetBelowStalactiteTip((Level)level, tipPos);
        if (targetPos == null) {
            return false;
        }
        BlockState sourceBlock = DripstoneRecipe.getBlockAboveStalactite((Level)level, blockPos, blockState);
        if (sourceBlock == null) {
            return false;
        }
        BlockState targetBlock = level.m_8055_(targetPos);
        Pair result = RecipeTypes.DRIPSTONE_DRIPPING.process((Level)level, targetBlock, () -> {
            DripstoneContext.Builder builder = new DripstoneContext.Builder((Level)level, sourceBlock);
            builder.withParameter(LootContextParams.f_81461_, targetBlock);
            Vec3 origin = new Vec3((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.99, (double)targetPos.m_123343_() + 0.5);
            builder.withParameter(LootContextParams.f_81460_, origin);
            builder.withParameter(LycheeLootContextParams.BLOCK_POS, targetPos);
            return builder.create(LycheeLootContextParamSets.BLOCK_ONLY);
        });
        if (result == null) {
            return false;
        }
        DripstoneContext ctx = result.getFirst();
        DripstoneRecipe recipe = (DripstoneRecipe)result.getSecond();
        level.m_46796_(1504, tipPos, 0);
        int i = tipPos.m_123342_() - targetPos.m_123342_();
        int j = 50 + i;
        Break breakAction = new Break();
        LocationPredicate.Builder builder = new LocationPredicate.Builder().m_52652_(recipe.targetBlock);
        LocationCheck check = (LocationCheck)LocationCheck.m_81725_((LocationPredicate.Builder)builder).m_6409_();
        breakAction.withCondition(new Not(new Location(check)));
        ctx.runtime.jobs.push(new Job(breakAction, 1));
        ctx.runtime.jobs.push(new Job(new Delay((float)j / 20.0f), 1));
        ctx.runtime.run(recipe, ctx);
        return true;
    }

    @Nullable
    private static BlockPos findTargetBelowStalactiteTip(Level level, BlockPos blockPos2) {
        Predicate<BlockState> predicate = blockState -> !blockState.m_60795_() && RecipeTypes.DRIPSTONE_DRIPPING.has((BlockState)blockState);
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> PointedDripstoneBlockAccess.callCanDripThrough((BlockGetter)level, blockPos, blockState);
        return PointedDripstoneBlockAccess.callFindBlockVertical((LevelAccessor)level, blockPos2, Direction.DOWN.m_122421_(), biPredicate, predicate, 11).orElse(null);
    }

    public static BlockState getBlockAboveStalactite(Level level, BlockPos blockPos2, BlockState blockState) {
        return PointedDripstoneBlockAccess.callFindRootBlock(level, blockPos2, blockState, 11).map(blockPos -> level.m_8055_(blockPos.m_7494_())).orElse(null);
    }

    public static class Serializer
    extends LycheeRecipe.Serializer<DripstoneRecipe> {
        public Serializer() {
            super(DripstoneRecipe::new);
        }

        @Override
        public void fromJson(DripstoneRecipe pRecipe, JsonObject pSerializedRecipe) {
            pRecipe.sourceBlock = BlockPredicateHelper.fromJson(pSerializedRecipe.get("source_block"));
            pRecipe.targetBlock = BlockPredicateHelper.fromJson(pSerializedRecipe.get("target_block"));
            Preconditions.checkArgument((pRecipe.sourceBlock != BlockPredicate.f_17902_ ? 1 : 0) != 0, (Object)"source_block can't be wildcard");
            Preconditions.checkArgument((pRecipe.targetBlock != BlockPredicate.f_17902_ ? 1 : 0) != 0, (Object)"target_block can't be wildcard");
        }

        @Override
        public void fromNetwork(DripstoneRecipe pRecipe, FriendlyByteBuf pBuffer) {
            pRecipe.sourceBlock = BlockPredicateHelper.fromNetwork(pBuffer);
            pRecipe.targetBlock = BlockPredicateHelper.fromNetwork(pBuffer);
        }

        @Override
        public void toNetwork0(FriendlyByteBuf pBuffer, DripstoneRecipe pRecipe) {
            BlockPredicateHelper.toNetwork(pRecipe.sourceBlock, pBuffer);
            BlockPredicateHelper.toNetwork(pRecipe.targetBlock, pBuffer);
        }
    }
}

