/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.json;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class JsonPointer {
    public final List<String> tokens;

    public JsonPointer(Collection<String> tokens) {
        this.tokens = List.copyOf(tokens);
    }

    public JsonPointer(String path) {
        if (path.isEmpty()) {
            this.tokens = List.of();
        } else if (path.codePointAt(0) == 47) {
            this.tokens = List.of(path.substring(1).split("/"));
        } else {
            throw new IllegalArgumentException(path);
        }
    }

    public String toString() {
        if (this.isRoot()) {
            return "";
        }
        return "/" + Joiner.on((char)'/').join(this.tokens);
    }

    @Nullable
    public JsonElement find(JsonElement doc) {
        if (this.isRoot()) {
            return doc;
        }
        JsonElement element = doc;
        try {
            for (String token : this.tokens) {
                if (element.isJsonArray()) {
                    element = element.getAsJsonArray().get(Integer.parseInt(token));
                    continue;
                }
                if (element.isJsonObject()) {
                    element = element.getAsJsonObject().get(token);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
        catch (Exception e) {
            return null;
        }
        return element;
    }

    public int size() {
        return this.tokens.size();
    }

    public String getString(int index) {
        if (index < 0) {
            index = this.tokens.size() + index;
        }
        return this.tokens.get(index);
    }

    public int getInt(int index) {
        return Integer.parseInt(this.getString(index));
    }

    public boolean isRoot() {
        return this.tokens.isEmpty();
    }

    public JsonPointer parent() {
        ArrayList list = Lists.newArrayList(this.tokens);
        list.remove(list.size() - 1);
        return new JsonPointer(list);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JsonPointer) {
            return this.tokens.equals(((JsonPointer)obj).tokens);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.tokens);
    }

    public JsonPointer append(String token) {
        return new JsonPointer(this + "/" + token);
    }

    public boolean isSelfOrParentOf(List<String> tokens1) {
        if (this.tokens.size() < tokens1.size()) {
            return false;
        }
        for (int i = 0; i < tokens1.size(); ++i) {
            if (Objects.equals(this.tokens.get(i), tokens1.get(i))) continue;
            return false;
        }
        return true;
    }

    public static class Serializer
    implements JsonDeserializer<JsonPointer>,
    JsonSerializer<JsonPointer> {
        public JsonElement serialize(JsonPointer src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }

        public JsonPointer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new JsonPointer(json.getAsString());
        }
    }
}

