/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.block;

import io.ticticboom.mods.mm.block.entity.PortBlockEntity;
import io.ticticboom.mods.mm.client.container.PortMenuProvider;
import io.ticticboom.mods.mm.ports.base.IPortBE;
import io.ticticboom.mods.mm.ports.base.IPortBlock;
import io.ticticboom.mods.mm.setup.model.PortModel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class PortBlock
extends Block
implements EntityBlock,
IPortBlock {
    private final PortModel model;
    private RegistryObject<MenuType<?>> menuType;
    private RegistryObject<BlockEntityType<BlockEntity>> blockEntityType;

    public PortBlock(PortModel model, RegistryObject<MenuType<?>> menuType, RegistryObject<BlockEntityType<BlockEntity>> blockEntityType) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_));
        this.model = model;
        this.menuType = menuType;
        this.blockEntityType = blockEntityType;
    }

    @Override
    public PortModel model() {
        return this.model;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level level, BlockPos pos) {
        PortBlockEntity be = (PortBlockEntity)level.m_7702_(pos);
        return new PortMenuProvider(be, (MenuType)this.menuType.get(), this.model);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        PortBlockEntity be = (PortBlockEntity)level.m_7702_(pos);
        InteractionResult ires = be.storage.playerInteractWithItem(player, level, pos, hand);
        if (!ires.equals((Object)InteractionResult.PASS)) {
            return ires;
        }
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this.m_7246_(state, level, pos), (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)this.blockEntityType.get()).m_155264_(pos, state);
    }

    public void m_6810_(BlockState p_60515_, Level level, BlockPos pos, BlockState p_60518_, boolean p_60519_) {
        IPortBE port = (IPortBE)level.m_7702_(pos);
        if (port == null) {
            return;
        }
        port.storage().onDestroy(level, pos);
        super.m_6810_(p_60515_, level, pos, p_60518_, p_60519_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == this.blockEntityType.get() ? PortBlockEntity::tick : null;
    }
}

