/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.block.entity;

import dev.latvian.mods.kubejs.event.EventJS;
import io.ticticboom.mods.mm.block.ControllerBlock;
import io.ticticboom.mods.mm.compat.kube.MMEvents;
import io.ticticboom.mods.mm.compat.kube.machine.MachineRecipeCompleteHandler;
import io.ticticboom.mods.mm.ports.base.IOPortStorage;
import io.ticticboom.mods.mm.recipe.IRecipeEntryContext;
import io.ticticboom.mods.mm.recipe.MMRecipeEntry;
import io.ticticboom.mods.mm.recipe.RecipeContext;
import io.ticticboom.mods.mm.setup.MMRegistries;
import io.ticticboom.mods.mm.setup.model.RecipeModel;
import io.ticticboom.mods.mm.setup.model.StructureModel;
import io.ticticboom.mods.mm.setup.reload.RecipeManager;
import io.ticticboom.mods.mm.setup.reload.StructureManager;
import io.ticticboom.mods.mm.structure.MMStructurePart;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ControllerBlockEntity
extends BlockEntity {
    private int ticks = 0;
    private int resetTicks = 0;
    public final DisplayInfo displayInfo = new DisplayInfo();
    public RecipeContext recipeContext;
    private final DecimalFormat format = new DecimalFormat("###.00");

    public ControllerBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("DisplayInfo", (Tag)this.displayInfo.serialize());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.displayInfo.deserialize(tag.m_128469_("DisplayInfo"));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.displayInfo.deserialize(pkt.m_131708_().m_128469_("DisplayInfo"));
    }

    public void forceUpdate() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.m_6596_();
        ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.m_58899_());
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (level.f_46443_) {
            return;
        }
        ControllerBlockEntity be = (ControllerBlockEntity)t;
        ControllerBlock block = (ControllerBlock)blockState.m_60734_();
        boolean foundAny = false;
        block0: for (Map.Entry<ResourceLocation, StructureModel> entry : StructureManager.REGISTRY.entrySet()) {
            ArrayList<IOPortStorage> inputPorts = new ArrayList<IOPortStorage>();
            ArrayList<IOPortStorage> outputPorts = new ArrayList<IOPortStorage>();
            StructureModel model = entry.getValue();
            if (!model.controllerId().equals((Object)block.model().id())) continue;
            for (StructureModel.TypedTransformedParts flattened : model.transformed()) {
                boolean found = true;
                for (StructureModel.PlacedStructurePart placed : flattened.parts()) {
                    MMStructurePart part = (MMStructurePart)MMRegistries.STRUCTURE_PARTS.get().getValue(placed.partId());
                    assert (part != null);
                    BlockPos expectedPos = blockPos.m_121955_((Vec3i)placed.pos());
                    if (!part.validatePlacement(level, expectedPos, placed.part())) {
                        found = false;
                        break;
                    }
                    Optional<IOPortStorage> port = part.getPortIfPresent(level, expectedPos, placed.part());
                    if (!port.isPresent()) continue;
                    if (port.get().input()) {
                        inputPorts.add(port.get());
                        continue;
                    }
                    outputPorts.add(port.get());
                }
                if (!found) continue;
                be.displayInfo.structureName = model.name().getString();
                be.forceUpdate();
                foundAny = true;
                be.chooseRecipe(model, new RecipeContext(model, null, flattened.transformId(), inputPorts, outputPorts, be.f_58857_, blockPos, new ArrayList<IRecipeEntryContext>()));
                continue block0;
            }
        }
        if (!foundAny) {
            be.displayInfo.structureName = "";
            be.forceUpdate();
        }
    }

    public void resetRecipe() {
        this.ticks = 0;
        this.displayInfo.processStatus = "Idle";
        this.displayInfo.recipe = "";
        if (this.recipeContext != null) {
            for (IOPortStorage outputPort : this.recipeContext.outputPorts()) {
                outputPort.port().reset();
            }
            for (IOPortStorage input : this.recipeContext.inputPorts()) {
                input.port().reset();
            }
        }
    }

    protected void chooseRecipe(StructureModel model, RecipeContext ctx) {
        boolean foundAny = false;
        for (Map.Entry<ResourceLocation, RecipeModel> recipe : RecipeManager.REGISTRY.entrySet()) {
            int n;
            if (!recipe.getValue().structureId().toString().equals(model.id().toString())) continue;
            boolean found = true;
            RecipeContext nctx = new RecipeContext(ctx.structure(), recipe.getValue(), ctx.appliedTransformId(), ctx.inputPorts(), ctx.outputPorts(), ctx.level(), ctx.controllerPos(), new ArrayList<IRecipeEntryContext>());
            RecipeContext cloned = nctx.clonePorts();
            for (RecipeModel.RecipeEntry recipeEntry : recipe.getValue().inputs()) {
                MMRecipeEntry entry = (MMRecipeEntry)MMRegistries.RECIPE_ENTRIES.get().getValue(recipeEntry.type());
                if (entry.processInputs(recipeEntry.config(), nctx, cloned)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            boolean canOutput = true;
            for (Object input3 : recipe.getValue().outputs()) {
                MMRecipeEntry entry = (MMRecipeEntry)MMRegistries.RECIPE_ENTRIES.get().getValue(((RecipeModel.RecipeEntry)input3).type());
                if (entry.processOutputs(((RecipeModel.RecipeEntry)input3).config(), nctx, cloned)) continue;
                canOutput = false;
                this.displayInfo.processStatus = "Cannot Output";
            }
            if (!found || !canOutput) continue;
            this.recipeContext = nctx;
            ++this.ticks;
            int n2 = recipe.getValue().duration();
            for (RecipeModel.RecipeEntry input4 : recipe.getValue().inputs()) {
                MMRecipeEntry entry = (MMRecipeEntry)MMRegistries.RECIPE_ENTRIES.get().getValue(input4.type());
                n = entry.getNewTickLimit(input4.config(), nctx, cloned, n);
            }
            float percentage = (float)this.ticks / (float)n;
            this.displayInfo.processStatus = this.format.format(100.0f * percentage) + "% Processing";
            this.displayInfo.recipe = recipe.getValue().name().getString();
            if (this.ticks >= n) {
                MMRecipeEntry entry;
                MMEvents.RECIPE_COMPLETE.post((EventJS)new MachineRecipeCompleteHandler(this.m_58899_(), this, model));
                for (RecipeModel.RecipeEntry input5 : recipe.getValue().inputs()) {
                    entry = (MMRecipeEntry)MMRegistries.RECIPE_ENTRIES.get().getValue(input5.type());
                    entry.processInputs(input5.config(), nctx, nctx);
                }
                for (RecipeModel.RecipeEntry output : recipe.getValue().outputs()) {
                    entry = (MMRecipeEntry)MMRegistries.RECIPE_ENTRIES.get().getValue(output.type());
                    entry.processOutputs(output.config(), nctx, nctx);
                }
                this.ticks = 0;
            }
            foundAny = true;
            break;
        }
        if (!foundAny) {
            this.resetRecipe();
        }
        this.forceUpdate();
    }

    public static class DisplayInfo {
        public String structureName;
        public String processStatus;
        public String recipe;

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            if (this.structureName != null) {
                tag.m_128359_("Structure", this.structureName);
            }
            if (this.processStatus != null) {
                tag.m_128359_("Status", this.processStatus);
            }
            if (this.recipe != null) {
                tag.m_128359_("Recipe", this.recipe);
            }
            return tag;
        }

        public void deserialize(CompoundTag tag) {
            if (tag.m_128441_("Structure")) {
                this.structureName = tag.m_128461_("Structure");
            }
            if (tag.m_128441_("Status")) {
                this.processStatus = tag.m_128461_("Status");
            }
            if (tag.m_128441_("Recipe")) {
                this.recipe = tag.m_128461_("Recipe");
            }
        }
    }
}

