/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.block.entity;

import io.ticticboom.mods.mm.ports.base.IPortBE;
import io.ticticboom.mods.mm.ports.base.MMPortTypeEntry;
import io.ticticboom.mods.mm.ports.base.PortStorage;
import io.ticticboom.mods.mm.setup.MMRegistries;
import io.ticticboom.mods.mm.setup.model.PortModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PortBlockEntity
extends BlockEntity
implements IPortBE {
    public final PortStorage storage;
    private final PortModel model;

    public PortBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_, PortModel model) {
        super(p_155228_, p_155229_, p_155230_);
        this.model = model;
        MMPortTypeEntry port = MMRegistries.PORTS.get(model.port());
        this.storage = port.createStorage(model.configuredPort());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return this.storage.getCapability(cap);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return this.getCapability(cap);
    }

    public void forceUpdate() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.m_6596_();
        ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.m_58899_());
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Port", (Tag)this.storage.write());
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.storage.read(tag.m_128469_("Port"));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.storage.read(pkt.m_131708_().m_128469_("Port"));
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("Port", (Tag)this.storage.write());
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        this.storage.read(tag.m_128469_("Port"));
        super.m_142466_(tag);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (level.f_46443_) {
            return;
        }
        PortBlockEntity be = (PortBlockEntity)t;
        be.forceUpdate();
        be.storage.tick();
    }

    @Override
    public PortModel model() {
        return this.model;
    }

    @Override
    public PortStorage storage() {
        return this.storage;
    }
}

