/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.datagen.gen;

import com.google.gson.JsonElement;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.setup.MMRegistries;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.RegistryObject;

public class MMLootTableProvider
extends LootTableProvider {
    protected final Map<Block, LootTable.Builder> blockLootTable = new HashMap<Block, LootTable.Builder>();
    private DataGenerator gen;

    public MMLootTableProvider(DataGenerator gen) {
        super(gen);
        this.gen = gen;
    }

    public void m_213708_(CachedOutput cache) {
        for (RegistryObject entry : MMRegistries.BLOCKS.getEntries()) {
            LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((Block)entry.get()).m_5456_()));
            this.blockLootTable.put((Block)entry.get(), LootTable.m_79147_().m_79161_(pool));
        }
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<Block, LootTable.Builder> entry : this.blockLootTable.entrySet()) {
            tables.put(entry.getKey().m_60589_(), entry.getValue().m_79165_(LootContextParamSets.f_81421_).m_79167_());
        }
        this.writeTables(cache, tables);
    }

    private void writeTables(CachedOutput cache, Map<ResourceLocation, LootTable> tables) {
        Path output = this.gen.m_123916_();
        tables.forEach((key, val) -> {
            Path path = output.resolve("data/" + key.m_135827_() + "/loot_tables/" + key.m_135815_() + ".json");
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)LootTables.m_79200_((LootTable)val), (Path)path);
            }
            catch (IOException e) {
                Ref.LOG.error("Couldn't Write loot table {}", (Object)path, (Object)e);
            }
        });
    }
}

