/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.ports.fluid;

import io.ticticboom.mods.mm.capability.MMCapabilities;
import io.ticticboom.mods.mm.ports.base.PortStorage;
import io.ticticboom.mods.mm.ports.fluid.FluidConfiguredPort;
import io.ticticboom.mods.mm.ports.fluid.MMFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidPortStorage
extends PortStorage {
    public FluidConfiguredPort config;
    public final MMFluidTank handler;
    public final LazyOptional<MMFluidTank> handlerLO;

    @Override
    public InteractionResult playerInteractWithItem(Player player, Level level, BlockPos pos, InteractionHand hand) {
        if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.handler)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public FluidPortStorage(FluidConfiguredPort config) {
        this.config = config;
        this.handler = new MMFluidTank(config.capacity());
        this.handlerLO = LazyOptional.of(() -> this.handler);
    }

    @Override
    public void read(CompoundTag tag) {
        if (tag.m_128441_("Amount") && tag.m_128441_("Fluid")) {
            int amount = tag.m_128451_("Amount");
            String fluidId = tag.m_128461_("Fluid");
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.m_135820_((String)fluidId));
            this.handler.setStack(new FluidStack(fluid, amount));
        }
    }

    @Override
    public CompoundTag write() {
        CompoundTag result = new CompoundTag();
        result.m_128359_("Fluid", ForgeRegistries.FLUIDS.getKey((Object)this.handler.stack().getFluid()).toString());
        result.m_128405_("Amount", this.handler.stack().getAmount());
        return result;
    }

    @Override
    public void onDestroy(Level level, BlockPos pos) {
    }

    @Override
    public PortStorage deepClone() {
        FluidPortStorage result = new FluidPortStorage(this.config);
        result.handler.setStack(this.handler.stack().copy());
        return result;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (cap == MMCapabilities.FLUIDS) {
            return this.handlerLO.cast();
        }
        return LazyOptional.empty();
    }
}

