/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.ports.fluid;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.ports.base.IConfiguredIngredient;
import io.ticticboom.mods.mm.ports.base.IConfiguredPort;
import io.ticticboom.mods.mm.ports.base.MMPortTypeEntry;
import io.ticticboom.mods.mm.ports.base.PortStorage;
import io.ticticboom.mods.mm.ports.fluid.FluidConfiguredIngredient;
import io.ticticboom.mods.mm.ports.fluid.FluidConfiguredPort;
import io.ticticboom.mods.mm.ports.fluid.FluidPortStorage;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidPortTypeEntry
extends MMPortTypeEntry {
    @Override
    public Class<? extends PortStorage> storageClass() {
        return FluidPortStorage.class;
    }

    @Override
    public IConfiguredPort parse(JsonObject element) {
        return new FluidConfiguredPort(element.get("capacity").getAsInt());
    }

    @Override
    public IConfiguredIngredient parseIngredient(JsonObject json) {
        ResourceLocation fluid = ResourceLocation.m_135820_((String)json.get("fluid").getAsString());
        int amount = json.get("amount").getAsInt();
        return new FluidConfiguredIngredient(fluid, amount);
    }

    @Override
    public ResourceLocation overlay(boolean input) {
        if (input) {
            return Ref.res("block/base_ports/fluid_input_cutout");
        }
        return Ref.res("block/base_ports/fluid_output_cutout");
    }

    @Override
    public PortStorage createStorage(IConfiguredPort config) {
        return new FluidPortStorage((FluidConfiguredPort)config);
    }

    @Override
    public boolean processInputs(IConfiguredIngredient ingredient, List<PortStorage> storage) {
        FluidConfiguredIngredient conf = (FluidConfiguredIngredient)ingredient;
        int counter = 0;
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(conf.fluid());
        FluidStack fs = new FluidStack(fluid, conf.amount());
        for (PortStorage portStorage : storage) {
            if (!(portStorage instanceof FluidPortStorage)) continue;
            FluidPortStorage fps = (FluidPortStorage)portStorage;
            FluidStack drained = fps.handler.drain(fs, IFluidHandler.FluidAction.EXECUTE);
            if ((counter += drained.getAmount()) < conf.amount()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean processOutputs(IConfiguredIngredient ingredient, List<PortStorage> storage) {
        FluidConfiguredIngredient conf = (FluidConfiguredIngredient)ingredient;
        int counter = 0;
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(conf.fluid());
        FluidStack fs = new FluidStack(fluid, conf.amount());
        for (PortStorage portStorage : storage) {
            if (!(portStorage instanceof FluidPortStorage)) continue;
            FluidPortStorage fps = (FluidPortStorage)portStorage;
            int drained = fps.handler.fill(fs, IFluidHandler.FluidAction.EXECUTE);
            if ((counter += drained) < conf.amount()) continue;
            return true;
        }
        return false;
    }
}

