/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.ports.js;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.ports.base.IConfiguredIngredient;
import io.ticticboom.mods.mm.ports.base.IConfiguredPort;
import io.ticticboom.mods.mm.ports.base.MMPortTypeEntry;
import io.ticticboom.mods.mm.ports.base.PortStorage;
import io.ticticboom.mods.mm.ports.js.ConfiguredIngredientJS;
import io.ticticboom.mods.mm.ports.js.ConfiguredPortJS;
import io.ticticboom.mods.mm.ports.js.PortStorageJS;
import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public class PortTypeEntryJS
extends MMPortTypeEntry {
    private OverlayCallback overlay;
    private ProcessIOCallback processInputs;
    private ProcessIOCallback processOutputs;
    private Function<ConfiguredPortJS, PortStorageJS> storageFactory;

    public PortTypeEntryJS(OverlayCallback overlay, ProcessIOCallback processInputs, ProcessIOCallback processOutputs, Function<ConfiguredPortJS, PortStorageJS> storageFactory) {
        this.overlay = overlay;
        this.processInputs = processInputs;
        this.processOutputs = processOutputs;
        this.storageFactory = storageFactory;
    }

    @Override
    public Class<? extends PortStorage> storageClass() {
        return PortStorageJS.class;
    }

    @Override
    public IConfiguredPort parse(JsonObject element) {
        return new ConfiguredPortJS(element);
    }

    @Override
    public IConfiguredIngredient parseIngredient(JsonObject json) {
        return new ConfiguredIngredientJS(json);
    }

    @Override
    public ResourceLocation overlay(boolean input) {
        if (this.overlay == null) {
            return input ? Ref.res("block/base_ports/item_input_cutout") : Ref.res("block/base_ports/item_output_cutout");
        }
        return ResourceLocation.m_135820_((String)this.overlay.run(input));
    }

    @Override
    public PortStorage createStorage(IConfiguredPort config) {
        return this.storageFactory.apply((ConfiguredPortJS)config);
    }

    @Override
    public boolean processInputs(IConfiguredIngredient ingredient, List<PortStorage> storage) {
        return this.processIO(ingredient, storage, this.processInputs);
    }

    @Override
    public boolean processOutputs(IConfiguredIngredient ingredient, List<PortStorage> storage) {
        return this.processIO(ingredient, storage, this.processOutputs);
    }

    private boolean processIO(IConfiguredIngredient ingredient, List<PortStorage> storage, ProcessIOCallback processor) {
        ConfiguredIngredientJS conf = (ConfiguredIngredientJS)ingredient;
        JsonObject state = new JsonObject();
        for (PortStorage portStorage : storage) {
            if (!(portStorage instanceof PortStorageJS)) continue;
            PortStorageJS psjs = (PortStorageJS)portStorage;
            boolean result = processor.run(conf.config(), psjs.data, state);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface OverlayCallback {
        public String run(boolean var1);
    }

    @FunctionalInterface
    public static interface ProcessIOCallback {
        public boolean run(JsonObject var1, JsonObject var2, JsonObject var3);
    }
}

