/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.ports.mekanism;

import io.ticticboom.mods.mm.ports.base.PortStorage;
import io.ticticboom.mods.mm.ports.mekanism.MekChemicalConfiguredPort;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class MekChemicalPortStorage<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends PortStorage {
    public IChemicalTank<CHEMICAL, STACK> tank;
    public MekChemicalConfiguredPort config;
    private final LazyOptional<IChemicalTank<CHEMICAL, STACK>> handlerLO;

    protected abstract IChemicalTank<CHEMICAL, STACK> createTank(long var1);

    protected abstract boolean isCapability(Capability<?> var1);

    protected abstract STACK createStack(ResourceLocation var1, long var2);

    protected abstract MekChemicalPortStorage<CHEMICAL, STACK> createSelf();

    public MekChemicalPortStorage(MekChemicalConfiguredPort config) {
        this.tank = this.createTank(config.capacity());
        this.config = config;
        this.handlerLO = LazyOptional.of(() -> this.tank);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (this.isCapability(cap)) {
            return this.handlerLO.cast();
        }
        return super.getCapability(cap);
    }

    @Override
    public void read(CompoundTag tag) {
        String gas = tag.m_128461_("Chemical");
        long amount = tag.m_128454_("Amount");
        this.tank.setStack(this.createStack(ResourceLocation.m_135820_((String)gas), amount));
    }

    @Override
    public CompoundTag write() {
        CompoundTag result = new CompoundTag();
        ChemicalStack stack = this.tank.getStack();
        result.m_128359_("Chemical", stack.getRaw().getRegistryName().toString());
        result.m_128356_("Amount", stack.getAmount());
        return result;
    }

    @Override
    public void onDestroy(Level level, BlockPos pos) {
    }

    @Override
    public PortStorage deepClone() {
        MekChemicalPortStorage<CHEMICAL, STACK> res = this.createSelf();
        res.tank = this.createTank(this.config.capacity());
        res.tank.setStack(this.tank.getStack().copy());
        return res;
    }
}

