/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.ports.mekanism;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.ports.base.IConfiguredIngredient;
import io.ticticboom.mods.mm.ports.base.IConfiguredPort;
import io.ticticboom.mods.mm.ports.base.MMPortTypeEntry;
import io.ticticboom.mods.mm.ports.base.PortStorage;
import io.ticticboom.mods.mm.ports.mekanism.MekChemicalConfiguredIngredient;
import io.ticticboom.mods.mm.ports.mekanism.MekChemicalConfiguredPort;
import io.ticticboom.mods.mm.ports.mekanism.MekChemicalPortStorage;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.resources.ResourceLocation;

public abstract class MekChemicalPortTypeEntry<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends MMPortTypeEntry {
    private String chemicalKey;

    public MekChemicalPortTypeEntry(String chemicalKey) {
        this.chemicalKey = chemicalKey;
    }

    @Override
    public IConfiguredPort parse(JsonObject element) {
        long capacity = element.get("capacity").getAsLong();
        return new MekChemicalConfiguredPort(capacity);
    }

    @Override
    public IConfiguredIngredient parseIngredient(JsonObject json) {
        ResourceLocation gas = ResourceLocation.m_135820_((String)json.get("gas").getAsString());
        int amount = json.get("amount").getAsInt();
        return new MekChemicalConfiguredIngredient(gas, amount);
    }

    @Override
    public boolean processInputs(IConfiguredIngredient ingredient, List<PortStorage> storage) {
        MekChemicalConfiguredIngredient conf = (MekChemicalConfiguredIngredient)ingredient;
        long extracted = 0L;
        for (PortStorage portStorage : storage) {
            long extractAmount;
            if (portStorage.getClass() != this.storageClass()) continue;
            MekChemicalPortStorage gasS = (MekChemicalPortStorage)portStorage;
            if (!gasS.tank.getStack().getRaw().getRegistryName().toString().equals(conf.chemical().toString()) || (extracted = gasS.tank.extract(extractAmount = conf.amount() - extracted, Action.EXECUTE, AutomationType.EXTERNAL).getAmount()) < conf.amount()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean processOutputs(IConfiguredIngredient ingredient, List<PortStorage> storage) {
        MekChemicalConfiguredIngredient conf = (MekChemicalConfiguredIngredient)ingredient;
        long inserted = 0L;
        for (PortStorage portStorage : storage) {
            if (portStorage.getClass() != this.storageClass()) continue;
            MekChemicalPortStorage gasS = (MekChemicalPortStorage)portStorage;
            Object stack = gasS.createStack(conf.chemical(), conf.amount() - inserted);
            inserted = conf.amount() - gasS.tank.insert(stack, Action.EXECUTE, AutomationType.EXTERNAL).getAmount();
            if (inserted < conf.amount()) continue;
            return true;
        }
        return false;
    }
}

