/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.setup;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.ticticboom.mods.mm.Ref;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public class BaseJsonManager {
    protected static Path getConfigDirectory(String subdir) {
        Path path = FMLPaths.CONFIGDIR.get().resolve("mm");
        BaseJsonManager.createIfNotExist(path);
        Path result = path.resolve(subdir);
        BaseJsonManager.createIfNotExist(result);
        return result;
    }

    protected static void createIfNotExist(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                Ref.LOG.error("Failed to create path: {}", (Object)path.toAbsolutePath());
            }
        }
    }

    protected static List<JsonObject> loadFiles(Path path) {
        File file = path.toFile();
        if (!file.exists()) {
            Ref.LOG.fatal("file non existent upon reading, where TF has it gone between listing and reading hm Hm HMMMMM?!?!?!?!?!");
            return null;
        }
        ArrayList<JsonObject> result = new ArrayList<JsonObject>();
        File[] list = file.listFiles();
        if (list == null) {
            return result;
        }
        for (File s : list) {
            if (!s.exists()) {
                Ref.LOG.fatal("file non existent upon reading, where TF has it gone between listing and reading hm Hm HMMMMM?!?!?!?!?!");
                continue;
            }
            try {
                FileReader fr = new FileReader(s);
                JsonElement json = JsonParser.parseReader((Reader)fr);
                result.add(json.getAsJsonObject());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                Ref.LOG.fatal("Failed to read or parse file: {}", (Object)file.getAbsolutePath());
            }
        }
        return result;
    }
}

