/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.setup;

import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import io.ticticboom.mods.mm.ModRoot;
import io.ticticboom.mods.mm.block.ControllerBlock;
import io.ticticboom.mods.mm.block.entity.ControllerBlockEntity;
import io.ticticboom.mods.mm.client.container.ControllerContainer;
import io.ticticboom.mods.mm.compat.kube.MMEvents;
import io.ticticboom.mods.mm.compat.kube.controller.ControllerEventHandler;
import io.ticticboom.mods.mm.setup.BaseJsonManager;
import io.ticticboom.mods.mm.setup.MMRegistries;
import io.ticticboom.mods.mm.setup.model.ControllerModel;
import io.ticticboom.mods.mm.util.Deferred;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.RegistryObject;

public class ControllerManager
extends BaseJsonManager {
    public static Map<ResourceLocation, ControllerModel> REGISTRY = new HashMap<ResourceLocation, ControllerModel>();

    public static void load() {
        Path path = ControllerManager.getConfigDirectory("controllers");
        List<JsonObject> files = ControllerManager.loadFiles(path);
        if (files == null) {
            return;
        }
        for (JsonObject json : files) {
            ControllerModel res = ControllerModel.parse(json);
            REGISTRY.put(res.id(), res);
        }
        if (ModList.get().isLoaded("kubejs")) {
            MMEvents.CONTROLLER.post((ScriptTypeHolder)ScriptType.STARTUP, (EventJS)new ControllerEventHandler());
        }
        for (ControllerModel res : REGISTRY.values()) {
            Deferred<RegistryObject> blockEntityType = new Deferred<RegistryObject>();
            Deferred<RegistryObject> menuType = new Deferred<RegistryObject>();
            RegistryObject block = MMRegistries.BLOCKS.register(res.blockId().m_135815_(), () -> new ControllerBlock(res, (RegistryObject)blockEntityType.data, (RegistryObject)menuType.data));
            MMRegistries.ITEMS.register(res.blockId().m_135815_(), () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(ModRoot.MM_GROUP)));
            blockEntityType.set(MMRegistries.BLOCK_ENTITIES.register(res.blockId().m_135815_(), () -> BlockEntityType.Builder.m_155273_((a, b) -> new ControllerBlockEntity((BlockEntityType)((RegistryObject)blockEntityType.data).get(), a, b), (Block[])new Block[]{(Block)block.get()}).m_58966_(null)));
            menuType.set(MMRegistries.MENU_TYPES.register(res.blockId().m_135815_(), () -> IForgeMenuType.create((a, b, c) -> new ControllerContainer(a, b, c, (MenuType)((RegistryObject)menuType.data).get()))));
        }
    }
}

