/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.structure.port;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.ports.base.IOPortStorage;
import io.ticticboom.mods.mm.ports.base.IPortBE;
import io.ticticboom.mods.mm.ports.base.IPortBlock;
import io.ticticboom.mods.mm.structure.IConfiguredStructurePart;
import io.ticticboom.mods.mm.structure.MMStructurePart;
import io.ticticboom.mods.mm.structure.port.PortConfiguredStructurePart;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PortStructurePart
extends MMStructurePart {
    @Override
    public IConfiguredStructurePart parse(JsonObject json) {
        ResourceLocation port = ResourceLocation.m_135820_((String)json.get("port").getAsString());
        boolean input = json.get("input").getAsBoolean();
        Optional<String> id = Optional.empty();
        if (json.has("id")) {
            id = Optional.of(json.get("id").getAsString());
        }
        return new PortConfiguredStructurePart(port, input, id);
    }

    @Override
    public boolean validatePlacement(Level level, BlockPos expectedPos, IConfiguredStructurePart config) {
        PortConfiguredStructurePart conf = (PortConfiguredStructurePart)config;
        Block block = level.m_8055_(expectedPos).m_60734_();
        if (block instanceof IPortBlock) {
            IPortBlock port = (IPortBlock)block;
            if (!port.model().port().equals((Object)conf.port())) {
                return false;
            }
            return conf.input() == port.model().input();
        }
        return false;
    }

    @Override
    public Optional<IOPortStorage> getPortIfPresent(Level level, BlockPos expectedPos, IConfiguredStructurePart config) {
        PortConfiguredStructurePart conf = (PortConfiguredStructurePart)config;
        BlockEntity block = level.m_7702_(expectedPos);
        if (block instanceof IPortBE) {
            IPortBE be = (IPortBE)block;
            return Optional.of(new IOPortStorage(conf.id().isPresent() ? conf.id().get() : "", be.storage(), conf.input()));
        }
        return Optional.empty();
    }
}

