/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import mekanism.client.render.obj.OpaqueModelConfiguration;
import mekanism.client.render.obj.TransmitterBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.obj.ObjModel;
import org.jetbrains.annotations.Nullable;

public class TransmitterModel
implements IUnbakedGeometry<TransmitterModel> {
    private final ObjModel internal;
    @Nullable
    private final ObjModel glass;

    public TransmitterModel(ObjModel internalModel, @Nullable ObjModel glass) {
        this.internal = internalModel;
        this.glass = glass;
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new TransmitterBakedModel(this.internal, this.glass, owner, bakery, spriteGetter, modelTransform, overrides, modelLocation);
    }

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        OpaqueModelConfiguration opaqueContext = new OpaqueModelConfiguration(owner);
        HashSet<Material> combined = new HashSet<Material>(this.internal.getMaterials(owner, modelGetter, missingTextureErrors));
        combined.addAll(this.internal.getMaterials((IGeometryBakingContext)opaqueContext, modelGetter, missingTextureErrors));
        if (this.glass != null) {
            combined.addAll(this.glass.getMaterials(owner, modelGetter, missingTextureErrors));
            combined.addAll(this.glass.getMaterials((IGeometryBakingContext)opaqueContext, modelGetter, missingTextureErrors));
        }
        return combined;
    }
}

