/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import mekanism.common.Mekanism;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.block.BlockCardboardBox;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.lib.radiation.capability.DefaultRadiationEntity;
import mekanism.common.network.to_client.PacketPlayerData;
import mekanism.common.network.to_client.PacketRadiationData;
import mekanism.common.network.to_client.PacketResetPlayerClient;
import mekanism.common.network.to_client.PacketSecurityUpdate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonPlayerTracker {
    public CommonPlayerTracker() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!player.f_19853_.f_46443_) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Mekanism.packetHandler().sendTo(new PacketSecurityUpdate(), serverPlayer);
            MekanismCriteriaTriggers.LOGGED_IN.m_222618_(serverPlayer);
        }
    }

    @SubscribeEvent
    public void onPlayerLogoutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        Mekanism.playerState.clearPlayer(player.m_20148_(), false);
        Mekanism.playerState.clearPlayerServerSideOnly(player.m_20148_());
    }

    @SubscribeEvent
    public void onPlayerDimChangedEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Mekanism.playerState.clearPlayer(player.m_20148_(), false);
        Mekanism.playerState.reapplyServerSideOnly((Player)player);
        player.getCapability(Capabilities.RADIATION_ENTITY).ifPresent(c -> Mekanism.packetHandler().sendTo(PacketRadiationData.createPlayer(c.getRadiation()), player));
        RadiationManager.INSTANCE.updateClientRadiation(player);
    }

    @SubscribeEvent
    public void onPlayerStartTrackingEvent(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                Mekanism.packetHandler().sendTo(new PacketPlayerData(player.m_20148_()), serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public void attachCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            DefaultRadiationEntity.Provider radiationProvider = new DefaultRadiationEntity.Provider();
            event.addCapability(DefaultRadiationEntity.Provider.NAME, (ICapabilityProvider)radiationProvider);
            event.addListener(radiationProvider::invalidate);
        }
    }

    @SubscribeEvent
    public void cloneEvent(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(Capabilities.RADIATION_ENTITY).ifPresent(cap -> event.getEntity().getCapability(Capabilities.RADIATION_ENTITY).ifPresent(c -> c.deserializeNBT((Tag)((CompoundTag)cap.serializeNBT()))));
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public void respawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        player.getCapability(Capabilities.RADIATION_ENTITY).ifPresent(c -> {
            if (!event.isEndConquered()) {
                c.set(1.0E-7);
            }
            Mekanism.packetHandler().sendTo(PacketRadiationData.createPlayer(c.getRadiation()), player);
        });
        RadiationManager.INSTANCE.updateClientRadiation(player);
        Mekanism.packetHandler().sendToAll(new PacketResetPlayerClient(player.m_20148_()));
    }

    @SubscribeEvent
    public void rightClickEvent(PlayerInteractEvent.RightClickBlock blockEvent) {
        if (blockEvent.getEntity().m_6144_() && blockEvent.getLevel().m_8055_(blockEvent.getPos()).m_60734_() instanceof BlockCardboardBox) {
            blockEvent.setUseBlock(Event.Result.ALLOW);
            blockEvent.setUseItem(Event.Result.DENY);
        }
    }
}

