/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tags;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.chemical.ChemicalTags;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.common.Mekanism;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.resource.IResource;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ResourceType;
import mekanism.common.resource.ore.OreType;
import mekanism.common.tags.LazyTagLookup;
import mekanism.common.tags.TagUtils;
import mekanism.common.util.EnumUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class MekanismTags {
    public static void init() {
        Items.init();
        Blocks.init();
        Fluids.init();
        Gases.init();
        InfuseTypes.init();
        MobEffects.init();
        Slurries.init();
        TileEntityTypes.init();
    }

    private MekanismTags() {
    }

    public static class Items {
        public static final Table<ResourceType, PrimaryResource, TagKey<Item>> PROCESSED_RESOURCES = HashBasedTable.create();
        public static final Map<IResource, TagKey<Item>> PROCESSED_RESOURCE_BLOCKS = new HashMap<IResource, TagKey<Item>>();
        public static final Map<OreType, TagKey<Item>> ORES = new EnumMap<OreType, TagKey<Item>>(OreType.class);
        public static final TagKey<Item> CONFIGURATORS;
        public static final TagKey<Item> WRENCHES;
        public static final TagKey<Item> TOOLS_WRENCH;
        public static final TagKey<Item> PERSONAL_STORAGE;
        public static final TagKey<Item> BATTERIES;
        public static final TagKey<Item> RODS_PLASTIC;
        public static final TagKey<Item> FUELS;
        public static final TagKey<Item> FUELS_BIO;
        public static final TagKey<Item> SALT;
        public static final TagKey<Item> SAWDUST;
        public static final TagKey<Item> YELLOW_CAKE_URANIUM;
        public static final TagKey<Item> PELLETS_ANTIMATTER;
        public static final TagKey<Item> PELLETS_PLUTONIUM;
        public static final TagKey<Item> PELLETS_POLONIUM;
        public static final TagKey<Item> DUSTS_BRONZE;
        public static final TagKey<Item> DUSTS_CHARCOAL;
        public static final TagKey<Item> DUSTS_COAL;
        public static final TagKey<Item> DUSTS_DIAMOND;
        public static final TagKey<Item> DUSTS_EMERALD;
        public static final TagKey<Item> DUSTS_NETHERITE;
        public static final TagKey<Item> DUSTS_LAPIS;
        public static final TagKey<Item> DUSTS_LITHIUM;
        public static final TagKey<Item> DUSTS_OBSIDIAN;
        public static final TagKey<Item> DUSTS_QUARTZ;
        public static final TagKey<Item> DUSTS_REFINED_OBSIDIAN;
        public static final TagKey<Item> DUSTS_SALT;
        public static final TagKey<Item> DUSTS_STEEL;
        public static final TagKey<Item> DUSTS_SULFUR;
        public static final TagKey<Item> DUSTS_WOOD;
        public static final TagKey<Item> DUSTS_FLUORITE;
        public static final TagKey<Item> NUGGETS_BRONZE;
        public static final TagKey<Item> NUGGETS_REFINED_GLOWSTONE;
        public static final TagKey<Item> NUGGETS_REFINED_OBSIDIAN;
        public static final TagKey<Item> NUGGETS_STEEL;
        public static final TagKey<Item> INGOTS_BRONZE;
        public static final TagKey<Item> INGOTS_REFINED_GLOWSTONE;
        public static final TagKey<Item> INGOTS_REFINED_OBSIDIAN;
        public static final TagKey<Item> INGOTS_STEEL;
        public static final TagKey<Item> STORAGE_BLOCKS_BRONZE;
        public static final TagKey<Item> STORAGE_BLOCKS_CHARCOAL;
        public static final TagKey<Item> STORAGE_BLOCKS_REFINED_GLOWSTONE;
        public static final TagKey<Item> STORAGE_BLOCKS_REFINED_OBSIDIAN;
        public static final TagKey<Item> STORAGE_BLOCKS_STEEL;
        public static final TagKey<Item> STORAGE_BLOCKS_FLUORITE;
        public static final TagKey<Item> CIRCUITS;
        public static final TagKey<Item> CIRCUITS_BASIC;
        public static final TagKey<Item> CIRCUITS_ADVANCED;
        public static final TagKey<Item> CIRCUITS_ELITE;
        public static final TagKey<Item> CIRCUITS_ULTIMATE;
        public static final TagKey<Item> ALLOYS;
        public static final TagKey<Item> ALLOYS_BASIC;
        public static final TagKey<Item> ALLOYS_INFUSED;
        public static final TagKey<Item> ALLOYS_REINFORCED;
        public static final TagKey<Item> ALLOYS_ATOMIC;
        public static final TagKey<Item> FORGE_ALLOYS;
        public static final TagKey<Item> ALLOYS_ADVANCED;
        public static final TagKey<Item> ALLOYS_ELITE;
        public static final TagKey<Item> ALLOYS_ULTIMATE;
        public static final TagKey<Item> ENRICHED;
        public static final TagKey<Item> ENRICHED_CARBON;
        public static final TagKey<Item> ENRICHED_DIAMOND;
        public static final TagKey<Item> ENRICHED_OBSIDIAN;
        public static final TagKey<Item> ENRICHED_REDSTONE;
        public static final TagKey<Item> ENRICHED_GOLD;
        public static final TagKey<Item> ENRICHED_TIN;
        public static final TagKey<Item> DIRTY_DUSTS;
        public static final TagKey<Item> CLUMPS;
        public static final TagKey<Item> SHARDS;
        public static final TagKey<Item> CRYSTALS;
        public static final TagKey<Item> GEMS_FLUORITE;
        public static final TagKey<Item> MEKASUIT_HUD_RENDERER;
        public static final TagKey<Item> COLORABLE_WOOL;
        public static final TagKey<Item> COLORABLE_CARPETS;
        public static final TagKey<Item> COLORABLE_BEDS;
        public static final TagKey<Item> COLORABLE_GLASS;
        public static final TagKey<Item> COLORABLE_GLASS_PANES;
        public static final TagKey<Item> COLORABLE_TERRACOTTA;
        public static final TagKey<Item> COLORABLE_CANDLE;
        public static final TagKey<Item> COLORABLE_CONCRETE;
        public static final TagKey<Item> COLORABLE_CONCRETE_POWDER;
        public static final TagKey<Item> COLORABLE_BANNERS;
        public static final TagKey<Item> ARMORS_HELMETS_HAZMAT;
        public static final TagKey<Item> ARMORS_CHESTPLATES_HAZMAT;
        public static final TagKey<Item> ARMORS_LEGGINGS_HAZMAT;
        public static final TagKey<Item> ARMORS_BOOTS_HAZMAT;

        private static void init() {
        }

        private Items() {
        }

        private static TagKey<Item> forgeTag(String name) {
            return ItemTags.create((ResourceLocation)new ResourceLocation("forge", name));
        }

        private static TagKey<Item> tag(String name) {
            return ItemTags.create((ResourceLocation)Mekanism.rl(name));
        }

        static {
            for (PrimaryResource primaryResource : EnumUtils.PRIMARY_RESOURCES) {
                for (ResourceType type : EnumUtils.RESOURCE_TYPES) {
                    if (!type.usedByPrimary(primaryResource)) continue;
                    if (type.isVanilla() || type == ResourceType.DUST) {
                        PROCESSED_RESOURCES.put((Object)type, (Object)primaryResource, Items.forgeTag(type.getBaseTagPath() + "/" + primaryResource.getRegistrySuffix()));
                        continue;
                    }
                    PROCESSED_RESOURCES.put((Object)type, (Object)primaryResource, Items.tag(type.getBaseTagPath() + "/" + primaryResource.getRegistrySuffix()));
                }
                if (primaryResource.isVanilla()) continue;
                PROCESSED_RESOURCE_BLOCKS.put(primaryResource, Items.forgeTag("storage_blocks/" + primaryResource.getRegistrySuffix()));
                BlockResourceInfo rawResource = primaryResource.getRawResourceBlockInfo();
                if (rawResource == null) continue;
                PROCESSED_RESOURCE_BLOCKS.put(rawResource, Items.forgeTag("storage_blocks/" + rawResource.getRegistrySuffix()));
            }
            for (Enum enum_ : EnumUtils.ORE_TYPES) {
                ORES.put((OreType)enum_, Items.forgeTag("ores/" + ((OreType)enum_).getResource().getRegistrySuffix()));
            }
            CONFIGURATORS = Items.tag("configurators");
            WRENCHES = Items.forgeTag("wrenches");
            TOOLS_WRENCH = Items.forgeTag("tools/wrench");
            PERSONAL_STORAGE = Items.tag("personal_storage");
            BATTERIES = Items.forgeTag("batteries");
            RODS_PLASTIC = Items.forgeTag("rods/plastic");
            FUELS = Items.forgeTag("fuels");
            FUELS_BIO = Items.forgeTag("fuels/bio");
            SALT = Items.forgeTag("salt");
            SAWDUST = Items.forgeTag("sawdust");
            YELLOW_CAKE_URANIUM = Items.forgeTag("yellow_cake_uranium");
            PELLETS_ANTIMATTER = Items.forgeTag("pellets/antimatter");
            PELLETS_PLUTONIUM = Items.forgeTag("pellets/plutonium");
            PELLETS_POLONIUM = Items.forgeTag("pellets/polonium");
            DUSTS_BRONZE = Items.forgeTag("dusts/bronze");
            DUSTS_CHARCOAL = Items.forgeTag("dusts/charcoal");
            DUSTS_COAL = Items.forgeTag("dusts/coal");
            DUSTS_DIAMOND = Items.forgeTag("dusts/diamond");
            DUSTS_EMERALD = Items.forgeTag("dusts/emerald");
            DUSTS_NETHERITE = Items.forgeTag("dusts/netherite");
            DUSTS_LAPIS = Items.forgeTag("dusts/lapis");
            DUSTS_LITHIUM = Items.forgeTag("dusts/lithium");
            DUSTS_OBSIDIAN = Items.forgeTag("dusts/obsidian");
            DUSTS_QUARTZ = Items.forgeTag("dusts/quartz");
            DUSTS_REFINED_OBSIDIAN = Items.forgeTag("dusts/refined_obsidian");
            DUSTS_SALT = Items.forgeTag("dusts/salt");
            DUSTS_STEEL = Items.forgeTag("dusts/steel");
            DUSTS_SULFUR = Items.forgeTag("dusts/sulfur");
            DUSTS_WOOD = Items.forgeTag("dusts/wood");
            DUSTS_FLUORITE = Items.forgeTag("dusts/fluorite");
            NUGGETS_BRONZE = Items.forgeTag("nuggets/bronze");
            NUGGETS_REFINED_GLOWSTONE = Items.forgeTag("nuggets/refined_glowstone");
            NUGGETS_REFINED_OBSIDIAN = Items.forgeTag("nuggets/refined_obsidian");
            NUGGETS_STEEL = Items.forgeTag("nuggets/steel");
            INGOTS_BRONZE = Items.forgeTag("ingots/bronze");
            INGOTS_REFINED_GLOWSTONE = Items.forgeTag("ingots/refined_glowstone");
            INGOTS_REFINED_OBSIDIAN = Items.forgeTag("ingots/refined_obsidian");
            INGOTS_STEEL = Items.forgeTag("ingots/steel");
            STORAGE_BLOCKS_BRONZE = Items.forgeTag("storage_blocks/bronze");
            STORAGE_BLOCKS_CHARCOAL = Items.forgeTag("storage_blocks/charcoal");
            STORAGE_BLOCKS_REFINED_GLOWSTONE = Items.forgeTag("storage_blocks/refined_glowstone");
            STORAGE_BLOCKS_REFINED_OBSIDIAN = Items.forgeTag("storage_blocks/refined_obsidian");
            STORAGE_BLOCKS_STEEL = Items.forgeTag("storage_blocks/steel");
            STORAGE_BLOCKS_FLUORITE = Items.forgeTag("storage_blocks/fluorite");
            CIRCUITS = Items.forgeTag("circuits");
            CIRCUITS_BASIC = Items.forgeTag("circuits/basic");
            CIRCUITS_ADVANCED = Items.forgeTag("circuits/advanced");
            CIRCUITS_ELITE = Items.forgeTag("circuits/elite");
            CIRCUITS_ULTIMATE = Items.forgeTag("circuits/ultimate");
            ALLOYS = Items.tag("alloys");
            ALLOYS_BASIC = Items.tag("alloys/basic");
            ALLOYS_INFUSED = Items.tag("alloys/infused");
            ALLOYS_REINFORCED = Items.tag("alloys/reinforced");
            ALLOYS_ATOMIC = Items.tag("alloys/atomic");
            FORGE_ALLOYS = Items.forgeTag("alloys");
            ALLOYS_ADVANCED = Items.forgeTag("alloys/advanced");
            ALLOYS_ELITE = Items.forgeTag("alloys/elite");
            ALLOYS_ULTIMATE = Items.forgeTag("alloys/ultimate");
            ENRICHED = Items.tag("enriched");
            ENRICHED_CARBON = Items.tag("enriched/carbon");
            ENRICHED_DIAMOND = Items.tag("enriched/diamond");
            ENRICHED_OBSIDIAN = Items.tag("enriched/obsidian");
            ENRICHED_REDSTONE = Items.tag("enriched/redstone");
            ENRICHED_GOLD = Items.tag("enriched/gold");
            ENRICHED_TIN = Items.tag("enriched/tin");
            DIRTY_DUSTS = Items.tag("dirty_dusts");
            CLUMPS = Items.tag("clumps");
            SHARDS = Items.tag("shards");
            CRYSTALS = Items.tag("crystals");
            GEMS_FLUORITE = Items.forgeTag("gems/fluorite");
            MEKASUIT_HUD_RENDERER = Items.tag("mekasuit_hud_renderer");
            COLORABLE_WOOL = Items.tag("colorable/wool");
            COLORABLE_CARPETS = Items.tag("colorable/carpets");
            COLORABLE_BEDS = Items.tag("colorable/beds");
            COLORABLE_GLASS = Items.tag("colorable/glass");
            COLORABLE_GLASS_PANES = Items.tag("colorable/glass_panes");
            COLORABLE_TERRACOTTA = Items.tag("colorable/terracotta");
            COLORABLE_CANDLE = Items.tag("colorable/candle");
            COLORABLE_CONCRETE = Items.tag("colorable/concrete");
            COLORABLE_CONCRETE_POWDER = Items.tag("colorable/concrete_powder");
            COLORABLE_BANNERS = Items.tag("colorable/banners");
            ARMORS_HELMETS_HAZMAT = Items.forgeTag("armors/armors/hazmat");
            ARMORS_CHESTPLATES_HAZMAT = Items.forgeTag("armors/chestplates/hazmat");
            ARMORS_LEGGINGS_HAZMAT = Items.forgeTag("armors/leggings/hazmat");
            ARMORS_BOOTS_HAZMAT = Items.forgeTag("armors/boots/hazmat");
        }
    }

    public static class Blocks {
        public static final Map<IResource, TagKey<Block>> RESOURCE_STORAGE_BLOCKS = new HashMap<IResource, TagKey<Block>>();
        public static final Map<OreType, TagKey<Block>> ORES = new EnumMap<OreType, TagKey<Block>>(OreType.class);
        public static final TagKey<Block> RELOCATION_NOT_SUPPORTED;
        public static final TagKey<Block> CARDBOARD_BLACKLIST;
        public static final TagKey<Block> MINER_BLACKLIST;
        public static final LazyTagLookup<Block> MINER_BLACKLIST_LOOKUP;
        public static final TagKey<Block> ATOMIC_DISASSEMBLER_ORE;
        public static final TagKey<Block> CHESTS_ELECTRIC;
        public static final TagKey<Block> CHESTS_PERSONAL;
        public static final TagKey<Block> BARRELS_PERSONAL;
        public static final TagKey<Block> PERSONAL_STORAGE;
        public static final TagKey<Block> STORAGE_BLOCKS_BRONZE;
        public static final TagKey<Block> STORAGE_BLOCKS_CHARCOAL;
        public static final TagKey<Block> STORAGE_BLOCKS_REFINED_GLOWSTONE;
        public static final TagKey<Block> STORAGE_BLOCKS_REFINED_OBSIDIAN;
        public static final TagKey<Block> STORAGE_BLOCKS_STEEL;
        public static final TagKey<Block> STORAGE_BLOCKS_FLUORITE;

        private static void init() {
        }

        private Blocks() {
        }

        private static TagKey<Block> forgeTag(String name) {
            return BlockTags.create((ResourceLocation)new ResourceLocation("forge", name));
        }

        private static TagKey<Block> tag(String name) {
            return BlockTags.create((ResourceLocation)Mekanism.rl(name));
        }

        static {
            for (PrimaryResource primaryResource : EnumUtils.PRIMARY_RESOURCES) {
                if (primaryResource.isVanilla()) continue;
                RESOURCE_STORAGE_BLOCKS.put(primaryResource, Blocks.forgeTag("storage_blocks/" + primaryResource.getRegistrySuffix()));
                BlockResourceInfo rawResource = primaryResource.getRawResourceBlockInfo();
                if (rawResource == null) continue;
                RESOURCE_STORAGE_BLOCKS.put(rawResource, Blocks.forgeTag("storage_blocks/" + rawResource.getRegistrySuffix()));
            }
            for (Enum enum_ : EnumUtils.ORE_TYPES) {
                ORES.put((OreType)enum_, Blocks.forgeTag("ores/" + ((OreType)enum_).getResource().getRegistrySuffix()));
            }
            RELOCATION_NOT_SUPPORTED = Blocks.forgeTag("relocation_not_supported");
            CARDBOARD_BLACKLIST = Blocks.tag("cardboard_blacklist");
            MINER_BLACKLIST = Blocks.tag("miner_blacklist");
            MINER_BLACKLIST_LOOKUP = LazyTagLookup.create(ForgeRegistries.BLOCKS, MINER_BLACKLIST);
            ATOMIC_DISASSEMBLER_ORE = Blocks.tag("atomic_disassembler_ore");
            CHESTS_ELECTRIC = Blocks.forgeTag("chests/electric");
            CHESTS_PERSONAL = Blocks.forgeTag("chests/personal");
            BARRELS_PERSONAL = Blocks.forgeTag("barrels/personal");
            PERSONAL_STORAGE = Blocks.tag("personal_storage");
            STORAGE_BLOCKS_BRONZE = Blocks.forgeTag("storage_blocks/bronze");
            STORAGE_BLOCKS_CHARCOAL = Blocks.forgeTag("storage_blocks/charcoal");
            STORAGE_BLOCKS_REFINED_GLOWSTONE = Blocks.forgeTag("storage_blocks/refined_glowstone");
            STORAGE_BLOCKS_REFINED_OBSIDIAN = Blocks.forgeTag("storage_blocks/refined_obsidian");
            STORAGE_BLOCKS_STEEL = Blocks.forgeTag("storage_blocks/steel");
            STORAGE_BLOCKS_FLUORITE = Blocks.forgeTag("storage_blocks/fluorite");
        }
    }

    public static class Fluids {
        public static final TagKey<Fluid> BRINE = Fluids.forgeTag("brine");
        public static final TagKey<Fluid> CHLORINE = Fluids.forgeTag("chlorine");
        public static final TagKey<Fluid> ETHENE = Fluids.forgeTag("ethene");
        public static final TagKey<Fluid> HEAVY_WATER = Fluids.forgeTag("heavy_water");
        public static final TagKey<Fluid> HYDROGEN = Fluids.forgeTag("hydrogen");
        public static final TagKey<Fluid> HYDROGEN_CHLORIDE = Fluids.forgeTag("hydrogen_chloride");
        public static final TagKey<Fluid> URANIUM_OXIDE = Fluids.forgeTag("uranium_oxide");
        public static final TagKey<Fluid> URANIUM_HEXAFLUORIDE = Fluids.forgeTag("uranium_hexafluoride");
        public static final TagKey<Fluid> LITHIUM = Fluids.forgeTag("lithium");
        public static final TagKey<Fluid> OXYGEN = Fluids.forgeTag("oxygen");
        public static final TagKey<Fluid> SODIUM = Fluids.forgeTag("sodium");
        public static final TagKey<Fluid> SUPERHEATED_SODIUM = Fluids.forgeTag("superheated_sodium");
        public static final TagKey<Fluid> STEAM = Fluids.forgeTag("steam");
        public static final TagKey<Fluid> SULFUR_DIOXIDE = Fluids.forgeTag("sulfur_dioxide");
        public static final TagKey<Fluid> SULFUR_TRIOXIDE = Fluids.forgeTag("sulfur_trioxide");
        public static final TagKey<Fluid> SULFURIC_ACID = Fluids.forgeTag("sulfuric_acid");
        public static final TagKey<Fluid> HYDROFLUORIC_ACID = Fluids.forgeTag("hydrofluoric_acid");
        public static final LazyTagLookup<Fluid> WATER_LOOKUP = LazyTagLookup.create(ForgeRegistries.FLUIDS, FluidTags.f_13131_);
        public static final LazyTagLookup<Fluid> LAVA_LOOKUP = LazyTagLookup.create(ForgeRegistries.FLUIDS, FluidTags.f_13132_);

        private static void init() {
        }

        private Fluids() {
        }

        private static TagKey<Fluid> forgeTag(String name) {
            return FluidTags.create((ResourceLocation)new ResourceLocation("forge", name));
        }
    }

    public static class Gases {
        public static final TagKey<Gas> WATER_VAPOR = Gases.tag("water_vapor");
        public static final TagKey<Gas> WASTE_BARREL_DECAY_BLACKLIST = Gases.tag("waste_barrel_decay_blacklist");
        public static final LazyTagLookup<Gas> WASTE_BARREL_DECAY_LOOKUP = LazyTagLookup.create(ChemicalTags.GAS, WASTE_BARREL_DECAY_BLACKLIST);

        private static void init() {
        }

        private Gases() {
        }

        private static TagKey<Gas> tag(String name) {
            return ChemicalTags.GAS.tag(Mekanism.rl(name));
        }
    }

    public static class InfuseTypes {
        public static final TagKey<InfuseType> CARBON = InfuseTypes.tag("carbon");
        public static final TagKey<InfuseType> REDSTONE = InfuseTypes.tag("redstone");
        public static final TagKey<InfuseType> DIAMOND = InfuseTypes.tag("diamond");
        public static final TagKey<InfuseType> REFINED_OBSIDIAN = InfuseTypes.tag("refined_obsidian");
        public static final TagKey<InfuseType> BIO = InfuseTypes.tag("bio");
        public static final TagKey<InfuseType> FUNGI = InfuseTypes.tag("fungi");
        public static final TagKey<InfuseType> GOLD = InfuseTypes.tag("gold");
        public static final TagKey<InfuseType> TIN = InfuseTypes.tag("tin");

        private static void init() {
        }

        private InfuseTypes() {
        }

        private static TagKey<InfuseType> tag(String name) {
            return ChemicalTags.INFUSE_TYPE.tag(Mekanism.rl(name));
        }
    }

    public static class MobEffects {
        public static final TagKey<MobEffect> SPEED_UP_BLACKLIST = MobEffects.tag("speed_up_blacklist");
        public static final LazyTagLookup<MobEffect> SPEED_UP_BLACKLIST_LOOKUP = LazyTagLookup.create(ForgeRegistries.MOB_EFFECTS, SPEED_UP_BLACKLIST);

        private static void init() {
        }

        private MobEffects() {
        }

        private static TagKey<MobEffect> tag(String name) {
            return TagUtils.createKey(ForgeRegistries.MOB_EFFECTS, Mekanism.rl(name));
        }
    }

    public static class Slurries {
        public static final TagKey<Slurry> DIRTY = Slurries.tag("dirty");
        public static final LazyTagLookup<Slurry> DIRTY_LOOKUP = LazyTagLookup.create(ChemicalTags.SLURRY, DIRTY);
        public static final TagKey<Slurry> CLEAN = Slurries.tag("clean");

        private static void init() {
        }

        private Slurries() {
        }

        private static TagKey<Slurry> tag(String name) {
            return ChemicalTags.SLURRY.tag(Mekanism.rl(name));
        }
    }

    public static class TileEntityTypes {
        public static final TagKey<BlockEntityType<?>> CARDBOARD_BLACKLIST = TileEntityTypes.tag("cardboard_blacklist");
        public static final LazyTagLookup<BlockEntityType<?>> CARDBOARD_BLACKLIST_LOOKUP = LazyTagLookup.create(ForgeRegistries.BLOCK_ENTITY_TYPES, CARDBOARD_BLACKLIST);
        public static final TagKey<BlockEntityType<?>> RELOCATION_NOT_SUPPORTED = TileEntityTypes.forgeTag("relocation_not_supported");
        public static final TagKey<BlockEntityType<?>> IMMOVABLE = TileEntityTypes.forgeTag("immovable");

        private static void init() {
        }

        private TileEntityTypes() {
        }

        private static TagKey<BlockEntityType<?>> tag(String name) {
            return TagUtils.createKey(ForgeRegistries.BLOCK_ENTITY_TYPES, Mekanism.rl(name));
        }

        private static TagKey<BlockEntityType<?>> forgeTag(String name) {
            return TagUtils.createKey(ForgeRegistries.BLOCK_ENTITY_TYPES, new ResourceLocation("forge", name));
        }
    }
}

