/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.laser;

import mekanism.api.IContentsListener;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.LaserEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.tile.laser.TileEntityLaserReceptor;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TileEntityLaserAmplifier
extends TileEntityLaserReceptor
implements IHasMode {
    private FloatingLong minThreshold = FloatingLong.ZERO;
    private FloatingLong maxThreshold;
    private int ticks;
    private int delay;
    private boolean emittingRedstone;
    private RedstoneOutput outputMode;

    public TileEntityLaserAmplifier(BlockPos pos, BlockState state) {
        super(MekanismBlocks.LASER_AMPLIFIER, pos, state);
        this.maxThreshold = (FloatingLong)MekanismConfig.storage.laserAmplifier.get();
        this.ticks = 0;
        this.delay = 0;
        this.outputMode = RedstoneOutput.OFF;
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD, this));
    }

    @Override
    protected void addInitialEnergyContainers(EnergyContainerHelper builder, IContentsListener listener) {
        this.energyContainer = LaserEnergyContainer.create(BasicEnergyContainer.alwaysTrue, BasicEnergyContainer.internalOnly, this, listener);
        builder.addContainer(this.energyContainer);
    }

    @Override
    protected void onUpdateServer() {
        this.setEmittingRedstone(false);
        this.ticks = this.ticks < this.delay ? ++this.ticks : 0;
        super.onUpdateServer();
        if (this.outputMode != RedstoneOutput.ENTITY_DETECTION) {
            this.setEmittingRedstone(false);
        }
    }

    @Override
    protected void setEmittingRedstone(boolean foundEntity) {
        this.emittingRedstone = foundEntity;
    }

    private boolean shouldFire() {
        return this.ticks >= this.delay && this.energyContainer.getEnergy().compareTo(this.minThreshold) >= 0 && MekanismUtils.canFunction(this);
    }

    @Override
    protected FloatingLong toFire() {
        return this.shouldFire() ? super.toFire().min(this.maxThreshold) : FloatingLong.ZERO;
    }

    @Override
    public int getRedstoneLevel() {
        if (this.outputMode == RedstoneOutput.ENERGY_CONTENTS) {
            return MekanismUtils.redstoneLevelFromContents(this.energyContainer.getEnergy(), this.energyContainer.getMaxEnergy());
        }
        return this.emittingRedstone ? 15 : 0;
    }

    @Override
    protected boolean makesComparatorDirty(@Nullable SubstanceType type) {
        return type == SubstanceType.ENERGY;
    }

    @Override
    protected void notifyComparatorChange() {
        this.f_58857_.m_46672_(this.m_58899_(), this.getBlockType());
    }

    public void setDelay(int delay) {
        if (this.delay != (delay = Math.max(0, delay))) {
            this.delay = delay;
            this.markForSave();
        }
    }

    @Override
    public void nextMode() {
        this.outputMode = (RedstoneOutput)this.outputMode.getNext();
        this.m_6596_();
    }

    @Override
    public void previousMode() {
        this.outputMode = (RedstoneOutput)this.outputMode.getPrevious();
        this.m_6596_();
    }

    public void setMinThresholdFromPacket(FloatingLong target) {
        if (this.updateMinThreshold(target)) {
            this.markForSave();
        }
    }

    public void setMaxThresholdFromPacket(FloatingLong target) {
        if (this.updateMaxThreshold(target)) {
            this.markForSave();
        }
    }

    private boolean updateMinThreshold(FloatingLong target) {
        FloatingLong threshold = this.getThreshold(target);
        if (!this.minThreshold.equals(threshold)) {
            this.minThreshold = threshold;
            if (this.minThreshold.greaterThan(this.maxThreshold)) {
                this.maxThreshold = this.minThreshold;
            }
            return true;
        }
        return false;
    }

    private boolean updateMaxThreshold(FloatingLong target) {
        FloatingLong threshold = this.getThreshold(target);
        if (!this.maxThreshold.equals(threshold)) {
            this.maxThreshold = threshold;
            if (this.maxThreshold.smallerThan(this.minThreshold)) {
                this.minThreshold = this.maxThreshold;
            }
            return true;
        }
        return false;
    }

    private FloatingLong getThreshold(FloatingLong target) {
        FloatingLong maxEnergy = this.energyContainer.getMaxEnergy();
        return target.smallerOrEqual(maxEnergy) ? target : maxEnergy.copyAsConst();
    }

    @Override
    protected void loadGeneralPersistentData(CompoundTag data) {
        super.loadGeneralPersistentData(data);
        NBTUtils.setFloatingLongIfPresent(data, "min", this::updateMinThreshold);
        NBTUtils.setFloatingLongIfPresent(data, "max", this::updateMaxThreshold);
        NBTUtils.setIntIfPresent(data, "time", value -> {
            this.delay = value;
        });
        NBTUtils.setEnumIfPresent(data, "outputMode", RedstoneOutput::byIndexStatic, mode -> {
            this.outputMode = mode;
        });
    }

    @Override
    protected void addGeneralPersistentData(CompoundTag data) {
        super.addGeneralPersistentData(data);
        data.m_128359_("min", this.minThreshold.toString());
        data.m_128359_("max", this.maxThreshold.toString());
        data.m_128405_("time", this.delay);
        NBTUtils.writeEnum(data, "outputMode", this.outputMode);
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @ComputerMethod(nameOverride="getRedstoneOutputMode")
    public RedstoneOutput getOutputMode() {
        return this.outputMode;
    }

    @ComputerMethod
    public int getDelay() {
        return this.delay;
    }

    @ComputerMethod
    public FloatingLong getMinThreshold() {
        return this.minThreshold;
    }

    @ComputerMethod
    public FloatingLong getMaxThreshold() {
        return this.maxThreshold;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableFloatingLong.create(this::getMinThreshold, value -> {
            this.minThreshold = value;
        }));
        container.track(SyncableFloatingLong.create(this::getMaxThreshold, value -> {
            this.maxThreshold = value;
        }));
        container.track(SyncableInt.create(this::getDelay, value -> {
            this.delay = value;
        }));
        container.track(SyncableEnum.create(RedstoneOutput::byIndexStatic, RedstoneOutput.OFF, this::getOutputMode, value -> {
            this.outputMode = value;
        }));
    }

    @ComputerMethod
    private void setRedstoneOutputMode(RedstoneOutput mode) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.outputMode != mode) {
            this.outputMode = mode;
            this.m_6596_();
        }
    }

    @ComputerMethod(nameOverride="setDelay")
    private void computerSetDelay(int delay) throws ComputerException {
        this.validateSecurityIsPublic();
        if (delay < 0) {
            throw new ComputerException("Delay cannot be negative. Received: %d", delay);
        }
        this.setDelay(delay);
    }

    @ComputerMethod
    private void setMinThreshold(FloatingLong threshold) throws ComputerException {
        this.validateSecurityIsPublic();
        this.setMinThresholdFromPacket(threshold);
    }

    @ComputerMethod
    private void setMaxThreshold(FloatingLong threshold) throws ComputerException {
        this.validateSecurityIsPublic();
        this.setMaxThresholdFromPacket(threshold);
    }

    @NothingNullByDefault
    public static enum RedstoneOutput implements IIncrementalEnum<RedstoneOutput>,
    IHasTranslationKey
    {
        OFF(MekanismLang.OFF),
        ENTITY_DETECTION(MekanismLang.ENTITY_DETECTION),
        ENERGY_CONTENTS(MekanismLang.ENERGY_CONTENTS);

        private static final RedstoneOutput[] MODES;
        private final ILangEntry langEntry;

        private RedstoneOutput(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public String getTranslationKey() {
            return this.langEntry.getTranslationKey();
        }

        @Override
        public RedstoneOutput byIndex(int index) {
            return RedstoneOutput.byIndexStatic(index);
        }

        public static RedstoneOutput byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        static {
            MODES = RedstoneOutput.values();
        }
    }
}

