/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim.datagen;

import io.github.noeppi_noeppi.mods.sandbox.datagen.ext.BiomeData;
import io.github.noeppi_noeppi.mods.sandbox.datagen.ext.base.WorldGenData;
import mythicbotany.alfheim.Alfheim;
import mythicbotany.alfheim.datagen.AlfheimFeatures;
import mythicbotany.alfheim.datagen.AlfheimPlacements;
import mythicbotany.register.ModEntities;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class AlfheimBiomes
extends BiomeData {
    private final AlfheimFeatures features = (AlfheimFeatures)this.resolve(AlfheimFeatures.class);
    private final AlfheimPlacements placements = (AlfheimPlacements)this.resolve(AlfheimPlacements.class);
    public final Holder<Biome> alfheimPlains;
    public final Holder<Biome> alfheimHills;
    public final Holder<Biome> dreamwoodForest;
    public final Holder<Biome> goldenFields;
    public final Holder<Biome> alfheimLakes;

    public AlfheimBiomes(WorldGenData.Properties properties) {
        super(properties);
        this.alfheimPlains = this.alfheimBiome(Alfheim.ALFHEIM_PLAINS, 0.9f, 1.0f).generation(this.alfheimGen().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.alfheimGrass).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.looseDreamwoodTrees).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.motifFlowers).m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, this.placements.abandonedApothecaries)).build();
        this.alfheimHills = this.alfheimBiome(Alfheim.ALFHEIM_HILLS, 0.9f, 1.0f).generation(this.alfheimGen().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.alfheimGrass).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.looseDreamwoodTrees).m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, this.placements.manaCrystals).m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, this.placements.abandonedApothecaries)).build();
        this.dreamwoodForest = this.alfheimBiome(Alfheim.DREAMWOOD_FOREST, 0.9f, 1.0f).generation(this.alfheimGen().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.alfheimGrass).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.denseDreamwoodTrees).m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, this.placements.abandonedApothecaries)).build();
        this.goldenFields = this.alfheimBiome(Alfheim.GOLDEN_FIELDS, 0.8f, 0.4f).effects(this.alfheimEffects().m_48034_(4566514).m_48037_(267827).m_48019_(12638463)).generation(this.alfheimGen().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.wheatFields).m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.extraGoldOre).m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, this.placements.abandonedApothecaries)).build();
        this.alfheimLakes = this.alfheimBiome(Alfheim.ALFHEIM_LAKES, 0.9f, 1.0f).effects(this.alfheimEffects().m_48034_(4566514).m_48037_(267827).m_48019_(12638463)).generation(this.alfheimGen().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.alfheimGrass).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.motifFlowers)).build();
    }

    public BiomeData.BiomeBuilder alfheimBiome(ResourceKey<Biome> key, float temperature, float downfall) {
        return this.biome(key, temperature, downfall).effects(this.alfheimEffects()).mobSpawns(this.alfheimSpawns());
    }

    public BiomeSpecialEffects.Builder alfheimEffects() {
        return this.effects().m_48034_(4445678).m_48037_(270131).m_48019_(12638463);
    }

    public MobSpawnSettings.Builder alfheimSpawns() {
        MobSpawnSettings.Builder builder = this.spawns().m_48368_(0.2f);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)builder);
        return builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.alfPixie, 5, 4, 10)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 2, 1, 2)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20459_, 1, 1, 1));
    }

    public BiomeGenerationSettings.Builder alfheimGen() {
        return this.generation().m_204198_(GenerationStep.Carving.AIR, this.features.cave).m_204198_(GenerationStep.Carving.AIR, this.features.canyon).m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.metamorphicForestStone).m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.metamorphicMountainStone).m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.metamorphicFungalStone).m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.metamorphicSwampStone).m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.metamorphicDesertStone).m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.metamorphicTaigaStone).m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.metamorphicMesaStone).m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.elementiumOre).m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.dragonstoneOre).m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.goldOre);
    }
}

