/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityChunkLoader;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;

public class BlockChunkLoader
extends BlockContainerImpl
implements IVisualizable,
ICustomBlockState {
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public BlockChunkLoader() {
        super("chunk_loader", BlockEntityChunkLoader.class, BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(3.0f).m_60918_(SoundType.f_56742_));
    }

    @Override
    protected boolean hasWaterlogging() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getVisualizationBounds(Level level, BlockPos pos) {
        int range;
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof BlockEntityChunkLoader && (range = ((BlockEntityChunkLoader)tile).range()) > 0) {
            return new AABB((double)(pos.m_123341_() - range >> 4 << 4), (double)level.m_141937_(), (double)(pos.m_123343_() - range >> 4 << 4), (double)((pos.m_123341_() + range >> 4 << 4) + 16), (double)level.m_151558_(), (double)((pos.m_123343_() + range >> 4 << 4) + 16));
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level levelIn, BlockPos pos, RandomSource rand) {
        BlockEntityChunkLoader loader;
        if (!((Boolean)ModConfig.instance.chunkLoader.get()).booleanValue()) {
            return;
        }
        BlockEntity tile = levelIn.m_7702_(pos);
        if (tile instanceof BlockEntityChunkLoader && (loader = (BlockEntityChunkLoader)tile).canUseRightNow(loader.getAuraUsed())) {
            for (int i = Mth.m_14167_((float)((float)loader.range() / 8.0f)); i > 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((float)pos.m_123341_() + levelIn.f_46441_.m_188501_(), (float)pos.m_123342_() + levelIn.f_46441_.m_188501_(), (float)pos.m_123343_() + levelIn.f_46441_.m_188501_(), 0.0, 0.0, 0.0, 10563071, 1.0f + levelIn.f_46441_.m_188501_(), 100, 0.0f, false, true);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(Level level, BlockPos pos) {
        return 12671481;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public String m_7705_() {
        return (Boolean)ModConfig.instance.chunkLoader.get() != false ? super.m_7705_() : "block.naturesaura." + this.getBaseName() + ".disabled";
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().getExistingFile(generator.modLoc(this.getBaseName())));
    }
}

