/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityFurnaceHeater;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BlockEntityBlastFurnaceBooster
extends BlockEntityImpl
implements ITickableBlockEntity {
    public BlockEntityBlastFurnaceBooster(BlockPos pos, BlockState state) {
        super(ModBlockEntities.BLAST_FURNACE_BOOSTER, pos, state);
    }

    @Override
    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        int toUse = 6500;
        if (!this.canUseRightNow(toUse)) {
            return;
        }
        BlockEntity below = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (!(below instanceof BlastFurnaceBlockEntity)) {
            return;
        }
        BlastFurnaceBlockEntity tile = (BlastFurnaceBlockEntity)below;
        Recipe recipe = this.f_58857_.m_7465_().m_44015_(BlockEntityFurnaceHeater.getRecipeType((AbstractFurnaceBlockEntity)tile), (Container)tile, this.f_58857_).orElse(null);
        if (recipe == null) {
            return;
        }
        if (!this.isApplicable((List<Ingredient>)recipe.m_7527_())) {
            return;
        }
        ContainerData data = BlockEntityFurnaceHeater.getFurnaceData((AbstractFurnaceBlockEntity)tile);
        int doneDiff = data.m_6413_(3) - data.m_6413_(2);
        if (doneDiff > 1) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188501_() > 0.45f) {
            PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), PacketParticles.Type.BLAST_FURNACE_BOOSTER, 0));
            return;
        }
        ItemStack output = tile.m_8020_(2);
        if (output.m_41613_() >= output.m_41741_()) {
            return;
        }
        if (output.m_41619_()) {
            ItemStack result = recipe.m_8043_();
            tile.m_6836_(2, result.m_41777_());
        } else {
            output.m_41769_(1);
        }
        BlockPos pos = IAuraChunk.getHighestSpot(this.f_58857_, this.f_58858_, 30, this.f_58858_);
        IAuraChunk.getAuraChunk(this.f_58857_, pos).drainAura(pos, toUse);
        PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), PacketParticles.Type.BLAST_FURNACE_BOOSTER, 1));
    }

    private boolean isApplicable(List<Ingredient> ingredients) {
        for (Ingredient ing : ingredients) {
            for (ItemStack stack : ing.m_43908_()) {
                if (!stack.m_204117_(Tags.Items.ORES) && !stack.m_204117_(Tags.Items.RAW_MATERIALS)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        BlockEntity below = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (!(below instanceof BlastFurnaceBlockEntity)) {
            return null;
        }
        final IItemHandler handler = (IItemHandler)below.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).orElse(null);
        if (handler == null) {
            return null;
        }
        return new IItemHandlerModifiable(){

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                if (handler instanceof IItemHandlerModifiable) {
                    ((IItemHandlerModifiable)handler).setStackInSlot(0, stack);
                }
            }

            public int getSlots() {
                return 1;
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(0);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return handler.insertItem(0, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return handler.extractItem(0, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(0);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return handler.isItemValid(0, stack);
            }
        };
    }

    @Override
    public void dropInventory() {
    }

    @Override
    public boolean allowsLowerLimiter() {
        return true;
    }
}

