/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemAuraBottle
extends ItemImpl
implements IColorProvidingItem,
ICustomItemModel {
    public ItemAuraBottle(Item emptyBottle) {
        super("aura_bottle");
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        DispenserBlock.m_52672_((ItemLike)emptyBottle, (source, stack) -> {
            ItemStack bottle;
            ServerLevel level = source.m_7727_();
            BlockState state = source.m_6414_();
            Direction facing = (Direction)state.m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos offset = source.m_7961_().m_121945_(facing);
            BlockState offsetState = level.m_8055_(offset);
            ItemStack dispense = stack.m_41620_(1);
            if (offsetState.m_60795_() && !(bottle = ItemAuraBottle.create((Level)level, offset)).m_41619_()) {
                dispense = bottle;
            }
            DefaultDispenseItemBehavior.m_123378_((Level)level, (ItemStack)dispense, (int)6, (Direction)facing, (Position)DispenserBlock.m_52720_((BlockSource)source));
            return stack;
        });
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_220152_(tab)) {
            for (IAuraType type : NaturesAuraAPI.AURA_TYPES.values()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                ItemAuraBottle.setType(stack, type);
                items.add((Object)stack);
            }
        }
    }

    public Component m_7626_(ItemStack stack) {
        return Component.m_237115_((String)(stack.m_41778_() + "." + ItemAuraBottle.getType(stack).getName()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor() {
        return (stack, tintIndex) -> tintIndex > 0 ? ItemAuraBottle.getType(stack).getColor() : 0xFFFFFF;
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/generated")).texture("layer0", "item/" + this.getBaseName())).texture("layer1", "item/" + this.getBaseName() + "_overlay");
    }

    public static IAuraType getType(ItemStack stack) {
        if (!stack.m_41782_()) {
            return NaturesAuraAPI.TYPE_OTHER;
        }
        String type = stack.m_41783_().m_128461_("stored_type");
        if (type.isEmpty()) {
            return NaturesAuraAPI.TYPE_OTHER;
        }
        return NaturesAuraAPI.AURA_TYPES.get(new ResourceLocation(type));
    }

    public static ItemStack setType(ItemStack stack, IAuraType type) {
        stack.m_41784_().m_128359_("stored_type", type.getName().toString());
        return stack;
    }

    private static ItemStack create(Level level, BlockPos pos) {
        int aura = IAuraChunk.getAuraInArea(level, pos, 30);
        if (aura <= -100000) {
            return new ItemStack((ItemLike)ModItems.VACUUM_BOTTLE);
        }
        if (aura >= 100000) {
            BlockPos spot = IAuraChunk.getHighestSpot(level, pos, 30, pos);
            IAuraChunk.getAuraChunk(level, spot).drainAura(spot, 20000);
            return ItemAuraBottle.setType(new ItemStack((ItemLike)ModItems.AURA_BOTTLE), IAuraType.forLevel(level));
        }
        return ItemStack.f_41583_;
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public void onRightClick(PlayerInteractEvent.RightClickItem event) {
            ItemStack held = event.getItemStack();
            if (held.m_41619_() || held.m_41720_() != ModItems.BOTTLE_TWO_THE_REBOTTLING) {
                return;
            }
            Player player = event.getEntity();
            BlockHitResult ray = ItemAuraBottle.m_41435_((Level)player.f_19853_, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (ray.m_6662_() == HitResult.Type.BLOCK) {
                return;
            }
            ItemStack bottle = ItemAuraBottle.create(player.f_19853_, player.m_20183_());
            if (bottle.m_41619_()) {
                return;
            }
            if (!player.f_19853_.f_46443_) {
                held.m_41774_(1);
                if (!player.m_36356_(bottle)) {
                    player.f_19853_.m_7967_((Entity)new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), bottle));
                }
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11771_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            player.m_6674_(event.getHand());
        }
    }
}

