/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.render.ITrinketItem;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.items.tools.ItemArmor;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ModArmorMaterial;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemShockwaveCreator
extends ItemImpl
implements ITrinketItem {
    public ItemShockwaveCreator() {
        super("shockwave_creator", new Item.Properties().m_41487_(1));
    }

    public void m_6883_(ItemStack stack, Level levelIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (levelIn.f_46443_ || !(entityIn instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entityIn;
        if (!living.m_20096_()) {
            CompoundTag compound = stack.m_41784_();
            if (compound.m_128471_("air")) {
                return;
            }
            compound.m_128379_("air", true);
            compound.m_128347_("x", living.m_20185_());
            compound.m_128347_("y", living.m_20186_());
            compound.m_128347_("z", living.m_20189_());
        } else {
            BlockPos pos;
            BlockPos down;
            BlockState downState;
            if (!stack.m_41782_()) {
                return;
            }
            CompoundTag compound = stack.m_41783_();
            if (!compound.m_128471_("air")) {
                return;
            }
            compound.m_128379_("air", false);
            if (!living.m_6144_()) {
                return;
            }
            if (living.m_20275_(compound.m_128459_("x"), compound.m_128459_("y"), compound.m_128459_("z")) > 0.75) {
                return;
            }
            if (living instanceof Player && !NaturesAuraAPI.instance().extractAuraFromPlayer((Player)living, 1000, false)) {
                return;
            }
            DamageSource source = living instanceof Player ? DamageSource.m_19344_((Player)((Player)living)) : DamageSource.f_19319_;
            boolean infusedSet = ItemArmor.isFullSetEquipped(living, ModArmorMaterial.INFUSED);
            int range = 5;
            List mobs = levelIn.m_45976_(LivingEntity.class, new AABB(living.m_20185_() - (double)range, living.m_20186_() - 0.5, living.m_20189_() - (double)range, living.m_20185_() + (double)range, living.m_20186_() + 0.5, living.m_20189_() + (double)range));
            for (LivingEntity mob : mobs) {
                if (!mob.m_6084_() || mob == living || living.m_20280_((Entity)mob) > (double)(range * range)) continue;
                if (living instanceof Player && !NaturesAuraAPI.instance().extractAuraFromPlayer((Player)living, 500, false)) break;
                mob.m_6469_(source, 4.0f);
                if (!infusedSet) continue;
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 120));
            }
            if ((downState = levelIn.m_8055_(down = (pos = living.m_20183_()).m_7495_())).m_60767_() != Material.f_76296_) {
                SoundType type = downState.m_60734_().getSoundType(downState, (LevelReader)levelIn, down, null);
                levelIn.m_5594_(null, pos, type.m_56775_(), SoundSource.BLOCKS, type.m_56773_() * 0.5f, type.m_56774_() * 0.8f);
            }
            PacketHandler.sendToAllAround(levelIn, pos, 32, new PacketParticles((float)living.m_20185_(), (float)living.m_20186_(), (float)living.m_20189_(), PacketParticles.Type.SHOCKWAVE_CREATOR, new int[0]));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(ItemStack stack, Player player, ITrinketItem.RenderType type, PoseStack matrices, MultiBufferSource buffer, int packedLight, boolean isHolding) {
        if (type == ITrinketItem.RenderType.BODY && !isHolding) {
            boolean armor = !((ItemStack)player.m_150109_().f_35975_.get(EquipmentSlot.CHEST.m_20749_())).m_41619_();
            matrices.m_85837_(0.0, 0.125, armor ? (double)-0.195f : (double)-0.1475f);
            matrices.m_85841_(0.3f, 0.3f, 0.3f);
            matrices.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, packedLight, OverlayTexture.f_118083_, matrices, buffer, 0);
        }
    }
}

