/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.packet;

import de.ellpeck.naturesaura.items.ItemRangeVisualizer;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class PacketClient {
    private int type;
    private CompoundTag data;

    public PacketClient(int type, CompoundTag data) {
        this.type = type;
        this.data = data;
    }

    private PacketClient() {
    }

    public static PacketClient fromBytes(FriendlyByteBuf buf) {
        PacketClient client = new PacketClient();
        client.type = buf.readByte();
        client.data = buf.m_130260_();
        return client;
    }

    public static void toBytes(PacketClient packet, FriendlyByteBuf buf) {
        buf.writeByte(packet.type);
        buf.m_130079_(packet.data);
    }

    public static void onMessage(final PacketClient message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91073_ != null) {
                    switch (message.type) {
                        case 0: {
                            ResourceLocation goalDim = new ResourceLocation(message.data.m_128461_("dim"));
                            BlockPos goalPos = BlockPos.m_122022_((long)message.data.m_128454_("pos"));
                            ItemRangeVisualizer.visualize((Player)mc.f_91074_, ItemRangeVisualizer.VISUALIZED_RAILS, goalDim, goalPos);
                        }
                        case 1: {
                            Entity entity = mc.f_91073_.m_6815_(message.data.m_128451_("id"));
                            mc.f_91061_.m_107332_(entity, (ParticleOptions)ParticleTypes.f_123767_, 30);
                            mc.f_91073_.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12513_, entity.m_5720_(), 1.0f, 1.0f, false);
                            if (entity != mc.f_91074_) break;
                            mc.f_91063_.m_109113_(new ItemStack((ItemLike)ModItems.DEATH_RING));
                        }
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

