/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.renderers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class SupporterFancyHandler {
    public static final Map<String, FancyInfo> FANCY_INFOS = new HashMap<String, FancyInfo>();

    public SupporterFancyHandler() {
        new FetchThread();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (!player.f_19853_.f_46443_) {
            return;
        }
        if (player.m_20145_() || !player.m_36170_(PlayerModelPart.CAPE)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (player == mc.f_91074_ && mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            return;
        }
        FancyInfo info = FANCY_INFOS.get(player.m_36316_().getName());
        if (info == null) {
            return;
        }
        RandomSource rand = player.f_19853_.f_46441_;
        if (rand.m_188501_() >= 0.75f) {
            int color;
            if (info.tier == 1) {
                BlockPos pos = player.m_20183_();
                color = BiomeColors.m_108793_((BlockAndTintGetter)player.f_19853_, (BlockPos)pos);
            } else {
                color = info.color;
            }
            NaturesAuraAPI.instance().spawnMagicParticle(player.m_20185_() + rand.m_188583_() * (double)0.15f, player.m_20186_() + (double)(rand.m_188501_() * 1.8f), player.m_20189_() + rand.m_188583_() * (double)0.15f, rand.m_188583_() * (double)0.01f, rand.m_188501_() * 0.01f, rand.m_188583_() * (double)0.01f, color, rand.m_188501_() + 1.0f, rand.m_188503_(50) + 50, 0.0f, false, true);
        }
    }

    private static class FetchThread
    extends Thread {
        public FetchThread() {
            this.setName("naturesaura_support_fetcher");
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                URL url = new URL("https://raw.githubusercontent.com/Ellpeck/NaturesAura/main/supporters.json");
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(url.openStream()));
                JsonObject main = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
                for (Map.Entry entry : main.entrySet()) {
                    JsonObject object = ((JsonElement)entry.getValue()).getAsJsonObject();
                    int tier = object.get("tier").getAsInt();
                    int color = object.has("color") ? Integer.parseInt(object.get("color").getAsString(), 16) : 0;
                    FANCY_INFOS.put((String)entry.getKey(), new FancyInfo(tier, color));
                }
                reader.close();
            }
            catch (Exception e) {
                NaturesAura.LOGGER.warn("Fetching supporter information failed", (Throwable)e);
            }
        }
    }

    public record FancyInfo(int tier, int color) {
    }
}

