/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.overworld;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.bytes.Byte2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;
import potionstudios.byg.mixin.access.ChunkAccessAccess;
import potionstudios.byg.util.DuneCache;

public class DuneFeature
extends Feature<NoneFeatureConfiguration> {
    protected static FastNoise fastNoise;
    protected static FastNoise fastNoise1;
    protected static FastNoise dunePeakNoise1;
    protected static FastNoise dunePeakNoise2;
    protected long seed;
    public static final double FREQUENCY = 0.006896551724137931;
    public static final double FREQUENCY_1 = 0.004;

    public DuneFeature(Codec<NoneFeatureConfiguration> $$0) {
        super($$0);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        WorldGenLevel level = featurePlaceContext.m_159774_();
        this.setSeed(level.m_7328_(), 0.0068965517f);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        ServerLevel serverLevel = level.m_6018_();
        DuneCache duneCache = (DuneCache)serverLevel;
        Long2ObjectOpenHashMap<Byte2ObjectOpenHashMap<ResourceKey<Biome>>> biomeAt = duneCache.getBiomeAt();
        if (biomeAt.size() > 4096) {
            biomeAt.clear();
        }
        Long2ObjectOpenHashMap<Byte2DoubleOpenHashMap> densityAt = duneCache.getDensityAt();
        for (int xMove = 0; xMove < 16; ++xMove) {
            for (int zMove = 0; zMove < 16; ++zMove) {
                mutableBlockPos.m_122190_((Vec3i)featurePlaceContext.m_159777_()).m_122184_(xMove, 0, zMove);
                ChunkAccess chunk = level.m_46865_((BlockPos)mutableBlockPos);
                float duneHeight = this.peakNoise(dunePeakNoise1, mutableBlockPos);
                float duneHeight1 = this.peakNoise(dunePeakNoise2, mutableBlockPos);
                double height = 180.0f + Math.max(duneHeight *= Mth.m_14179_((float)5.0f, (float)15.0f, (float)0.3f), duneHeight1 *= Mth.m_14179_((float)5.0f, (float)15.0f, (float)0.3f));
                BlockPos.MutableBlockPos blendingPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutableBlockPos);
                double density = this.getBlendDensity(biomeAt, level, chunkGenerator, chunk, mutableBlockPos, height, 10, blendingPos, 4);
                int oceanFloor = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, mutableBlockPos.m_123341_(), mutableBlockPos.m_123343_());
                int blendedDuneHeight = (int)Mth.m_14085_((double)(oceanFloor - 3), (double)height, (double)(1.0 - density));
                mutableBlockPos.m_142448_(blendedDuneHeight);
                for (int y = mutableBlockPos.m_123342_(); y >= oceanFloor; --y) {
                    BlockState generatingState = y == oceanFloor ? BYGBlocks.WINDSWEPT_SANDSTONE.defaultBlockState() : BYGBlocks.WINDSWEPT_SAND.defaultBlockState();
                    int localX = mutableBlockPos.m_123341_() & 0xF;
                    int localZ = mutableBlockPos.m_123343_() & 0xF;
                    chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG).m_64249_(localX, mutableBlockPos.m_123342_(), localZ, generatingState);
                    chunk.m_6005_(Heightmap.Types.WORLD_SURFACE_WG).m_64249_(localX, mutableBlockPos.m_123342_(), localZ, generatingState);
                    level.m_7731_((BlockPos)mutableBlockPos, generatingState, 2);
                    mutableBlockPos.m_122173_(Direction.DOWN);
                }
            }
        }
        return true;
    }

    private double getBlendDensity(Long2ObjectOpenHashMap<Byte2ObjectOpenHashMap<ResourceKey<Biome>>> biomeAt, WorldGenLevel level, ChunkGenerator generator, ChunkAccess chunk, BlockPos.MutableBlockPos mutableBlockPos, double height, int blendRange, BlockPos.MutableBlockPos blendingPos, int precision) {
        double density = 0.0;
        for (int x = -blendRange; x <= blendRange; x += precision) {
            for (int z = -blendRange; z <= blendRange; z += precision) {
                boolean caveCheck;
                blendingPos.m_122190_((Vec3i)mutableBlockPos).m_122184_(x, 0, z);
                int worldSurfaceHeight = level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, blendingPos.m_123341_(), blendingPos.m_123343_());
                blendingPos.m_142448_(worldSurfaceHeight);
                Byte2ObjectOpenHashMap localResourceKey = (Byte2ObjectOpenHashMap)biomeAt.computeIfAbsent(ChunkPos.m_151388_((BlockPos)blendingPos), key -> new Byte2ObjectOpenHashMap());
                ResourceKey biomeResourceKey = (ResourceKey)localResourceKey.computeIfAbsent(DuneCache.getLocalPackedCoord((BlockPos)blendingPos), key -> (ResourceKey)level.m_204166_((BlockPos)blendingPos).m_203543_().orElseThrow());
                boolean outsideBiome = (double)worldSurfaceHeight < height;
                NoiseChunk noiseChunk = ((ChunkAccessAccess)chunk).byg_getNoiseChunk();
                boolean abovePreliminarySurface = noiseChunk != null && noiseChunk.m_198256_(mutableBlockPos.m_123341_(), mutableBlockPos.m_123343_()) > worldSurfaceHeight;
                boolean bl = caveCheck = worldSurfaceHeight < generator.m_6337_() || abovePreliminarySurface;
                if (caveCheck) {
                    density += 1.0 / (double)precision / (double)(blendRange * blendRange) * 4.0;
                }
                if (!outsideBiome) continue;
                density += 1.0 / (double)precision / (double)(blendRange * blendRange) * 2.0;
            }
        }
        return Math.min(density, 1.0);
    }

    private float peakNoise(FastNoise noise, BlockPos.MutableBlockPos mutableBlockPos) {
        noise.SetFrequency(0.023f);
        noise.SetNoiseType(FastNoise.NoiseType.Cellular);
        noise.SetCellularDistanceFunction(FastNoise.CellularDistanceFunction.Euclidean);
        noise.SetCellularReturnType(FastNoise.CellularReturnType.Distance2Mul);
        noise.SetGradientPerturbAmp(1.5f);
        return 1.0f - noise.GetNoise(mutableBlockPos.m_123341_(), 0.0f, mutableBlockPos.m_123343_());
    }

    public void setSeed(long seed, float noiseFreq) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            fastNoise.SetFractalType(FastNoise.FractalType.RigidMulti);
            fastNoise.SetFractalOctaves(2);
            this.seed = seed;
            fastNoise1 = new FastNoise((int)seed);
            dunePeakNoise1 = new FastNoise((int)seed);
            dunePeakNoise2 = new FastNoise((int)seed + 76457567);
        }
    }
}

